/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.commands.ExtinguishCommand;
import com.glektarssza.gtnh_customizer.commands.ListDimensionsCommand;
import com.glektarssza.gtnh_customizer.commands.RepairCommand;
import com.glektarssza.gtnh_customizer.commands.TeleportCrossDimensionCommand;
import com.glektarssza.gtnh_customizer.config.Config;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import org.apache.logging.log4j.Logger;
import serverutils.events.ServerUtilitiesPreInitRegistryEvent;
import thaumcraft.common.blocks.BlockCustomPlant;

public class CommonProxy {
    private Logger logger;
    private File configDir;

    public int getViewDistanceChunks() {
        return MinecraftServer.getServer().getConfigurationManager().getViewDistance();
    }

    public int getViewDistanceBlocks() {
        return this.getViewDistanceChunks() * 16;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        GTNHCustomizer.getLogger().info("Pre-initializing server/common-side for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        this.configDir = event.getModConfigurationDirectory();
        Config.init(this.configDir, String.format("%s.cfg", "gtnh_customizer"));
        GTNHCustomizer.getLogger().info("Synchronizing configuration for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        Config.sync();
        GTNHCustomizer.getLogger().info("Registering mod {} with the Forge event bus...", new Object[]{"Gregtech: New Horizons Customizer"});
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        GTNHCustomizer.getLogger().info("Done pre-initializing server/common-side for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    public void init(FMLInitializationEvent event) {
        this.getLogger().info("Initializing server/common-side for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        this.getLogger().info("Done initializing server/common-side for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.getLogger().info("Post-initializing server/common-side for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        this.getLogger().info("Done post-initializing server/common-side for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    public void serverStarting(FMLServerStartingEvent event) {
        this.getLogger().info("Handling server about to start for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        this.getLogger().info("Registering custom commands for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        event.registerServerCommand((ICommand)new TeleportCrossDimensionCommand());
        event.registerServerCommand((ICommand)new ListDimensionsCommand());
        event.registerServerCommand((ICommand)new RepairCommand());
        event.registerServerCommand((ICommand)new ExtinguishCommand());
        this.getLogger().info("Done registering custom commands for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
        this.getLogger().info("Done handling server about to start for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    @SubscribeEvent
    public void serverUtilitiesPreInitRegistry(ServerUtilitiesPreInitRegistryEvent event) {
        GTNHCustomizer.getLogger().info("Pre-initializing server/common-side of Server Utilities stuff for {}...", new Object[]{"Gregtech: New Horizons Customizer"});
        event.getRegistry().registerServerReloadHandler(new ResourceLocation("gtnh_customizer", "config"), reloadEvent -> {
            try {
                Config.sync();
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        });
        GTNHCustomizer.getLogger().info("Done pre-initializing server/common-side of Server Utilities stuff for {}!", new Object[]{"Gregtech: New Horizons Customizer"});
    }

    @SubscribeEvent
    public void boneMeal(BonemealEvent event) {
        if (!Loader.isModLoaded((String)"Thaumcraft")) {
            return;
        }
        if (!(event.block instanceof BlockCustomPlant)) {
            return;
        }
        if (event.world.getBlockLightValue(event.x, event.y, event.z) < 9) {
            return;
        }
        switch (event.world.getBlockMetadata(event.x, event.y, event.z)) {
            case 0: {
                if (!Config.getThaumcraftCanBoneMealGreatwoodSaplings()) {
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                if (event.world.isRemote || (double)event.world.rand.nextFloat() >= 0.45) {
                    return;
                }
                ((BlockCustomPlant)event.block).growGreatTree(event.world, event.x, event.y, event.z, event.world.rand);
                break;
            }
            case 1: {
                if (!Config.getThaumcraftCanBoneMealSilverwoodSaplings()) {
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                if (event.world.isRemote || (double)event.world.rand.nextFloat() >= 0.45) {
                    return;
                }
                ((BlockCustomPlant)event.block).growSilverTree(event.world, event.x, event.y, event.z, event.world.rand);
            }
        }
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent event) {
        if (event.modID != "gtnh_customizer") {
            return;
        }
        Config.refresh();
        Config.save();
    }
}

