/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer;

import com.glektarssza.gtnh_customizer.CommonProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;

@Mod(modid="gtnh_customizer", name="Gregtech: New Horizons Customizer", version="v0.14.3", dependencies="after:serverutilities;after:TConstruct;after:XaeroMinimap;after:Thaumcraft;after:SpecialMobs", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.7.10]", modLanguage="java", guiFactory="com.glektarssza.gtnh_customizer.config.GuiFactory", canBeDeactivated=false, useMetadata=true)
public class GTNHCustomizer {
    @SidedProxy(modId="gtnh_customizer", serverSide="com.glektarssza.gtnh_customizer.CommonProxy", clientSide="com.glektarssza.gtnh_customizer.ClientProxy")
    private static CommonProxy proxy;
    public static final int WARNING_EMIT_LIMIT = 20;
    @Nonnull
    public static final Map<String, Integer> WARNING_LIMIT_TRACKER;
    @Mod.Instance
    private static GTNHCustomizer instance;
    @Mod.Metadata
    private static ModMetadata metadata;

    public static GTNHCustomizer getInstance() {
        return instance;
    }

    public static ModMetadata getMetadata() {
        return metadata;
    }

    public static Logger getLogger() {
        return proxy.getLogger();
    }

    @Nonnull
    public File getConfigDir() {
        return proxy.getConfigDir();
    }

    @Nonnull
    public static CommonProxy getProxy() {
        return proxy;
    }

    public static boolean shouldEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        return WARNING_LIMIT_TRACKER.get(category) > 0;
    }

    public static void trackEmitWarning(String category) {
        WARNING_LIMIT_TRACKER.putIfAbsent(category, 20);
        int limit = WARNING_LIMIT_TRACKER.compute(category, (_k, v) -> v - 1);
        if (limit <= 0) {
            GTNHCustomizer.getLogger().warn(String.format("Too many identical warnings logged for category \"%s\"! Silencing further warnings on this issue!", category));
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    static {
        WARNING_LIMIT_TRACKER = new HashMap<String, Integer>();
    }
}

