/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.GTNHCustomizer;
import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import com.glektarssza.gtnh_customizer.utils.IWorldExtensions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ExtinguishCommand
extends CommandBase {
    public static final int RANDOM_FIZZ_AUX_SFX_COMMAND = 1004;

    public String func_71517_b() {
        return "extinguish";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public String func_71518_a(ICommandSender sender) {
        return new ChatComponentTranslation("gtnh_customizer.commands.extinguish.usage", new Object[]{String.format("%d", GTNHCustomizer.getProxy().getViewDistanceBlocks())}).func_150261_e();
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        int index = args.length - 1;
        switch (index) {
            case 0: {
                return Arrays.asList("32", "~");
            }
            case 1: {
                return Collections.singletonList("~");
            }
            case 2: {
                return Collections.singletonList("~");
            }
            case 3: {
                return Collections.singletonList("~");
            }
            case 4: {
                return Collections.singletonList("~");
            }
            case 5: {
                return Collections.singletonList("~");
            }
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        ChunkCoordinates coords;
        Integer radius = null;
        Long startingBlockXPos = null;
        Long startingBlockYPos = null;
        Long startingBlockZPos = null;
        Long endingBlockXPos = null;
        Long endingBlockYPos = null;
        Long endingBlockZPos = null;
        if (args.length <= 1) {
            if (args.length == 0) {
                radius = ((IWorldExtensions)sender.func_130014_f_()).getRenderDistance() * 16;
            } else {
                try {
                    radius = Integer.parseUnsignedInt(args[0], 10);
                }
                catch (NumberFormatException ex) {
                    throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.invalid_radius", new Object[]{String.format("%d", args[0])});
                }
            }
            coords = sender.func_82114_b();
            startingBlockXPos = coords.field_71574_a - radius;
            startingBlockYPos = coords.field_71572_b - radius;
            startingBlockZPos = coords.field_71573_c - radius;
            endingBlockXPos = coords.field_71574_a + radius;
            endingBlockYPos = coords.field_71572_b + radius;
            endingBlockZPos = coords.field_71573_c + radius;
        } else if (args.length == 6) {
            long temp;
            coords = sender.func_82114_b();
            startingBlockXPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[0], coords.field_71574_a);
            startingBlockYPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[1], coords.field_71572_b);
            startingBlockZPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[2], coords.field_71573_c);
            endingBlockXPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[3], coords.field_71574_a);
            endingBlockYPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[4], coords.field_71572_b);
            endingBlockZPos = CommandUtils.parseBlockRelativeLongArgument(sender, args[5], coords.field_71573_c);
            if (endingBlockXPos < startingBlockXPos) {
                temp = startingBlockXPos;
                startingBlockXPos = endingBlockXPos;
                endingBlockXPos = temp;
            }
            if (endingBlockYPos < startingBlockYPos) {
                temp = startingBlockYPos;
                startingBlockYPos = endingBlockYPos;
                endingBlockYPos = temp;
            }
            if (endingBlockZPos < startingBlockZPos) {
                temp = startingBlockZPos;
                startingBlockZPos = endingBlockZPos;
                endingBlockZPos = temp;
            }
        } else {
            if (args.length < 6) {
                throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.not_enough_arguments", new Object[0]);
            }
            throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.wrong_usage", new Object[0]);
        }
        long volume = (endingBlockXPos - startingBlockXPos) * (endingBlockYPos - startingBlockYPos) * (endingBlockZPos - startingBlockZPos);
        if (volume > (long)Config.getExtinguishCommandMaxVolume()) {
            throw new WrongUsageException("gtnh_customizer.commands.extinguish.error.volume_too_large", new Object[]{String.format("%d", volume), String.format("%d", Config.getExtinguishCommandMaxVolume())});
        }
        World world = sender.func_130014_f_();
        for (long x = startingBlockXPos.longValue(); x < endingBlockXPos; ++x) {
            for (long y = startingBlockYPos.longValue(); y < endingBlockYPos; ++y) {
                for (long z = startingBlockZPos.longValue(); z < endingBlockZPos; ++z) {
                    Block block = world.func_147439_a((int)x, (int)y, (int)z);
                    if (block != Blocks.field_150480_ab) continue;
                    world.func_72889_a(null, 1004, (int)x, (int)y, (int)z, 0);
                    world.func_147468_f((int)x, (int)y, (int)z);
                }
            }
        }
        sender.func_145747_a(new ChatComponentTranslation("gtnh_customizer.commands.extinguish.info.success", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN).func_150217_b(Boolean.valueOf(true))));
        if (radius == null) {
            ExtinguishCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.extinguish.info.admin_notify.zone", (Object[])new Object[]{sender.func_70005_c_(), String.format("%d", startingBlockXPos), String.format("%d", startingBlockYPos), String.format("%d", startingBlockZPos), String.format("%d", endingBlockXPos), String.format("%d", endingBlockYPos), String.format("%d", endingBlockZPos)});
        } else {
            ExtinguishCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.extinguish.info.admin_notify.radius", (Object[])new Object[]{sender.func_70005_c_(), String.format("%d", radius)});
        }
    }
}

