/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import xonin.backhand.api.core.BackhandUtils;

public class RepairCommand
extends CommandBase {
    public String func_71517_b() {
        return "repair";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public String func_71518_a(ICommandSender sender) {
        return "gtnh_customizer.commands.repair.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0 && !this.isItemTargetIndex(args, index);
    }

    public boolean isItemTargetIndex(String[] args, int index) {
        if (index < 0 || index >= args.length) {
            return false;
        }
        return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(args[index])).findFirst().isPresent();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        List<String> result = null;
        int index = args.length - 1;
        switch (index) {
            case 0: {
                try {
                    victim = RepairCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                if (victim != null) {
                    result.addAll(0, Arrays.stream(ItemTarget.values()).filter(target -> target != ItemTarget.Offhand || Loader.isModLoaded((String)"backhand")).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList()));
                }
                return result;
            }
            case 1: {
                if (!this.func_82358_a(args, 0)) {
                    return null;
                }
                result = new ArrayList<String>(Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList()));
                return result;
            }
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        ItemTarget target = null;
        if (args.length > 1 && this.func_82358_a(args, 0)) {
            victim = RepairCommand.func_82359_c((ICommandSender)sender, (String)args[0]);
            target = ItemTarget.tryGetFromCommandArgument(args[1]);
            if (target == null) {
                throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target", new Object[]{args[1], Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "))});
            }
        } else if (args.length > 0) {
            victim = RepairCommand.func_71521_c((ICommandSender)sender);
            target = ItemTarget.tryGetFromCommandArgument(args[0]);
            if (target == null) {
                throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target", new Object[]{args[0], Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "))});
            }
        } else {
            victim = RepairCommand.func_71521_c((ICommandSender)sender);
            target = ItemTarget.Hand;
        }
        if (victim != null && target != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            switch (target) {
                case Hand: {
                    if (victim.func_70694_bm() == null) break;
                    items.add(victim.func_70694_bm());
                    break;
                }
                case Offhand: {
                    if (!Loader.isModLoaded((String)"backhand")) {
                        throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target.backhand_not_loaded", new Object[0]);
                    }
                    if (BackhandUtils.getOffhandItem((EntityPlayer)victim) == null) break;
                    items.add(BackhandUtils.getOffhandItem((EntityPlayer)victim));
                    break;
                }
                case Helmet: {
                    if (victim.field_71071_by.field_70460_b[3] == null) break;
                    items.add(victim.field_71071_by.field_70460_b[3]);
                    break;
                }
                case Chestplate: {
                    if (victim.field_71071_by.field_70460_b[2] == null) break;
                    items.add(victim.field_71071_by.field_70460_b[2]);
                    break;
                }
                case Leggings: {
                    if (victim.field_71071_by.field_70460_b[1] == null) break;
                    items.add(victim.field_71071_by.field_70460_b[1]);
                    break;
                }
                case Boots: {
                    if (victim.field_71071_by.field_70460_b[0] == null) break;
                    items.add(victim.field_71071_by.field_70460_b[0]);
                    break;
                }
                case Armor: {
                    items.addAll(Arrays.stream(victim.field_71071_by.field_70460_b).filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Hotbar: {
                    items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, 0, InventoryPlayer.func_70451_h())).stream().filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Inventory: {
                    if (Loader.isModLoaded((String)"backhand")) {
                        int offhandIndex = BackhandUtils.getOffhandSlot((EntityPlayer)victim);
                        if (offhandIndex < InventoryPlayer.func_70451_h()) {
                            items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, InventoryPlayer.func_70451_h(), victim.field_71071_by.field_70462_a.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                            break;
                        }
                        if (offhandIndex >= victim.field_71071_by.field_70462_a.length - 1) {
                            items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, InventoryPlayer.func_70451_h(), offhandIndex)).stream().filter(item -> item != null).collect(Collectors.toList()));
                            break;
                        }
                        items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, InventoryPlayer.func_70451_h(), offhandIndex)).stream().filter(item -> item != null).collect(Collectors.toList()));
                        items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, offhandIndex + 1, victim.field_71071_by.field_70462_a.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                        break;
                    }
                    items.addAll(Arrays.asList(Arrays.copyOfRange(victim.field_71071_by.field_70462_a, InventoryPlayer.func_70451_h() + 1, victim.field_71071_by.field_70462_a.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case All: 
                case Everything: {
                    items.addAll(Arrays.stream(victim.field_71071_by.field_70462_a).filter(item -> item != null).collect(Collectors.toList()));
                    items.addAll(Arrays.stream(victim.field_71071_by.field_70460_b).filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Container: {
                    Integer targetBlockPosX = null;
                    Integer targetBlockPosY = null;
                    Integer targetBlockPosZ = null;
                    TileEntity tileEntity = null;
                    IInventory tileInventory = null;
                    if (args.length >= 5 && this.func_82358_a(args, 0)) {
                        try {
                            targetBlockPosX = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[2], (int)victim.field_70165_t);
                            targetBlockPosY = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[3], (int)victim.field_70163_u);
                            targetBlockPosZ = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[4], (int)victim.field_70161_v);
                        }
                        catch (Throwable t) {
                            throw new CommandException("gtnh_customizer.commands.repair.error.bad_container_position", new Object[]{String.format("%d", args[2]), String.format("%d", args[3]), String.format("%d", args[4])});
                        }
                    } else if (args.length >= 4 && this.isItemTargetIndex(args, 0)) {
                        try {
                            targetBlockPosX = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[1], (int)victim.field_70165_t);
                            targetBlockPosY = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[2], (int)victim.field_70163_u);
                            targetBlockPosZ = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[3], (int)victim.field_70161_v);
                        }
                        catch (Throwable t) {
                            throw new CommandException("gtnh_customizer.commands.repair.error.bad_container_position", new Object[]{String.format("%d", args[1]), String.format("%d", args[2]), String.format("%d", args[3])});
                        }
                    } else {
                        double reach = victim.field_71134_c.getBlockReachDistance();
                        Vec3 start = Vec3.func_72443_a((double)victim.field_70165_t, (double)(victim.field_70163_u + (double)victim.func_70047_e()), (double)victim.field_70161_v);
                        Vec3 look = victim.func_70040_Z();
                        Vec3 end = start.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
                        MovingObjectPosition pos = victim.field_70170_p.func_147447_a(start, end, !Config.getRepairCommandRaycastIgnoresLiquids(), Config.getRepairCommandRaycastIgnoresLiquids(), false);
                        if (pos == null || pos.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                            throw new WrongUsageException("gtnh_customizer.commands.repair.error.no_container", new Object[0]);
                        }
                        targetBlockPosX = pos.field_72311_b;
                        targetBlockPosY = pos.field_72312_c;
                        targetBlockPosZ = pos.field_72309_d;
                    }
                    tileEntity = victim.field_70170_p.func_147438_o(targetBlockPosX.intValue(), targetBlockPosY.intValue(), targetBlockPosZ.intValue());
                    if (tileEntity instanceof IInventory) {
                        tileInventory = (IInventory)tileEntity;
                    }
                    if (!(tileInventory instanceof IInventory)) {
                        throw new WrongUsageException("gtnh_customizer.commands.repair.error.no_container", new Object[0]);
                    }
                    int slotCount = tileInventory.func_70302_i_();
                    for (int i = 0; i < slotCount; ++i) {
                        ItemStack itemStack2 = tileInventory.func_70301_a(i);
                        if (itemStack2 == null) continue;
                        items.add(itemStack2);
                    }
                    break;
                }
            }
            items.parallelStream().forEach(itemStack -> {
                NBTTagCompound stackTag;
                NBTTagCompound nBTTagCompound = stackTag = itemStack.func_77942_o() ? itemStack.field_77990_d : new NBTTagCompound();
                if (stackTag.func_150297_b("InfiTool", 10)) {
                    if (stackTag.func_74775_l("InfiTool").func_74762_e("Damage") > 0) {
                        stackTag.func_74775_l("InfiTool").func_74768_a("Damage", 0);
                        itemStack.func_77964_b(0);
                    }
                    if (stackTag.func_74775_l("InfiTool").func_74767_n("Broken")) {
                        stackTag.func_74775_l("InfiTool").func_74757_a("Broken", false);
                    }
                } else if (stackTag.func_150297_b("GT.ToolStats", 10) && stackTag.func_74775_l("GT.ToolStats").func_74762_e("Damage") > 0) {
                    stackTag.func_74775_l("GT.ToolStats").func_74768_a("Damage", 0);
                } else if (itemStack.func_77973_b().func_77645_m() && itemStack.func_77960_j() > 0) {
                    itemStack.func_77964_b(0);
                }
                if (stackTag.func_74764_b("RepairCost")) {
                    stackTag.func_82580_o("RepairCost");
                }
                itemStack.func_77982_d(stackTag);
            });
            sender.func_145747_a(new ChatComponentTranslation("gtnh_customizer.commands.repair.info.success", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN).func_150217_b(Boolean.valueOf(true))));
            RepairCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.repair.info.admin_notify", (Object[])new Object[]{sender.func_70005_c_(), String.format("%d", items.stream().mapToInt(itemStack -> itemStack.field_77994_a).sum())});
            return;
        }
        throw new WrongUsageException("gtnh_customizer.commands.repair.error.wrong_usage", new Object[0]);
    }

    public static enum ItemTarget {
        Hand("hand"),
        Offhand("offhand"),
        Helmet("helmet"),
        Chestplate("chestplate"),
        Leggings("leggings"),
        Boots("boots"),
        Armor("armor"),
        Hotbar("hotbar"),
        Inventory("inventory"),
        Everything("everything"),
        All("all"),
        Container("container");

        public final String commandValue;

        private ItemTarget(String commandValue) {
            this.commandValue = commandValue;
        }

        public static ItemTarget getFromCommandArgument(String argument) throws NoSuchElementException {
            return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(argument)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No ItemTarget with command value of '%s'", argument)));
        }

        @Nullable
        public static ItemTarget tryGetFromCommandArgument(String argument) {
            return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(argument)).findFirst().orElse(null);
        }
    }
}

