/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.late.enderzoo;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import crazypants.enderzoo.entity.EntityEnderminy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityEnderminy.class}, remap=false)
public abstract class EntityEnderminyMixin
extends EntityMob {
    private EntityEnderminyMixin(World theWorld) {
        super(theWorld);
    }

    @Inject(method={"findPlayerToAttack"}, at={@At(value="RETURN")}, cancellable=true)
    public void findPlayerToAttack$adjustReturnValue(CallbackInfoReturnable<Entity> cir) {
        Entity returnValue = (Entity)cir.getReturnValue();
        if (returnValue == null) {
            return;
        }
        if (!(returnValue instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)returnValue;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"shouldAttackPlayer"}, at={@At(value="RETURN")}, cancellable=true)
    public void shouldAttackPlayer$adjustReturnValue(EntityPlayer player, CallbackInfoReturnable<Boolean> cir) {
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"teleportTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void teleportTo$disableIfConfigured(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (Config.getPreventEnderMobTeleportation()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"doGroupArgo"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntitiesWithinAABB(Ljava/lang/Class;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;", remap=true)}, cancellable=true)
    public void doGroupArgo$cancelIfTargetingImmunePlayer(CallbackInfo ci) {
        if (this.field_70789_a == null) {
            return;
        }
        if (!(this.field_70789_a instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)this.field_70789_a;
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        if (PlayerUtils.getIsPlayerGloballyImmune(player)) {
            ci.cancel();
        }
    }
}

