/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.commands;

import com.glektarssza.gtnh_customizer.config.Config;
import com.glektarssza.gtnh_customizer.utils.CommandUtils;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import xonin.backhand.api.core.BackhandUtils;

public class RepairCommand
extends CommandBase {
    public String getCommandName() {
        return "repair";
    }

    public List<String> getCommandAliases() {
        return Collections.emptyList();
    }

    public String getCommandUsage(ICommandSender sender) {
        return "gtnh_customizer.commands.repair.usage";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public boolean isUsernameIndex(String[] args, int index) {
        return index == 0 && !this.isItemTargetIndex(args, index);
    }

    public boolean isItemTargetIndex(String[] args, int index) {
        if (index < 0 || index >= args.length) {
            return false;
        }
        return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(args[index])).findFirst().isPresent();
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        List<String> result = null;
        int index = args.length - 1;
        switch (index) {
            case 0: {
                try {
                    victim = RepairCommand.getPlayer((ICommandSender)sender, (String)args[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = CommandUtils.getTruncatedPlayerUsernameIterable(512);
                if (victim != null) {
                    result.addAll(0, Arrays.stream(ItemTarget.values()).filter(target -> target != ItemTarget.Offhand || Loader.isModLoaded((String)"backhand")).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList()));
                }
                return result;
            }
            case 1: {
                if (!this.isUsernameIndex(args, 0)) {
                    return null;
                }
                result = new ArrayList<String>(Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList()));
                return result;
            }
        }
        return null;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        EntityPlayerMP victim = null;
        ItemTarget target = null;
        if (args.length > 1 && this.isUsernameIndex(args, 0)) {
            victim = RepairCommand.getPlayer((ICommandSender)sender, (String)args[0]);
            target = ItemTarget.tryGetFromCommandArgument(args[1]);
            if (target == null) {
                throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target", new Object[]{args[1], Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "))});
            }
        } else if (args.length > 0) {
            victim = RepairCommand.getCommandSenderAsPlayer((ICommandSender)sender);
            target = ItemTarget.tryGetFromCommandArgument(args[0]);
            if (target == null) {
                throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target", new Object[]{args[0], Arrays.stream(ItemTarget.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "))});
            }
        } else {
            victim = RepairCommand.getCommandSenderAsPlayer((ICommandSender)sender);
            target = ItemTarget.Hand;
        }
        if (victim != null && target != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            switch (target) {
                case Hand: {
                    if (victim.getHeldItem() == null) break;
                    items.add(victim.getHeldItem());
                    break;
                }
                case Offhand: {
                    if (!Loader.isModLoaded((String)"backhand")) {
                        throw new WrongUsageException("gtnh_customizer.commands.repair.error.invalid_item_target.backhand_not_loaded", new Object[0]);
                    }
                    if (BackhandUtils.getOffhandItem((EntityPlayer)victim) == null) break;
                    items.add(BackhandUtils.getOffhandItem((EntityPlayer)victim));
                    break;
                }
                case Helmet: {
                    if (victim.inventory.armorInventory[3] == null) break;
                    items.add(victim.inventory.armorInventory[3]);
                    break;
                }
                case Chestplate: {
                    if (victim.inventory.armorInventory[2] == null) break;
                    items.add(victim.inventory.armorInventory[2]);
                    break;
                }
                case Leggings: {
                    if (victim.inventory.armorInventory[1] == null) break;
                    items.add(victim.inventory.armorInventory[1]);
                    break;
                }
                case Boots: {
                    if (victim.inventory.armorInventory[0] == null) break;
                    items.add(victim.inventory.armorInventory[0]);
                    break;
                }
                case Armor: {
                    items.addAll(Arrays.stream(victim.inventory.armorInventory).filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Hotbar: {
                    items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, 0, InventoryPlayer.getHotbarSize())).stream().filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Inventory: {
                    if (Loader.isModLoaded((String)"backhand")) {
                        int offhandIndex = BackhandUtils.getOffhandSlot((EntityPlayer)victim);
                        if (offhandIndex < InventoryPlayer.getHotbarSize()) {
                            items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, InventoryPlayer.getHotbarSize(), victim.inventory.mainInventory.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                            break;
                        }
                        if (offhandIndex >= victim.inventory.mainInventory.length - 1) {
                            items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, InventoryPlayer.getHotbarSize(), offhandIndex)).stream().filter(item -> item != null).collect(Collectors.toList()));
                            break;
                        }
                        items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, InventoryPlayer.getHotbarSize(), offhandIndex)).stream().filter(item -> item != null).collect(Collectors.toList()));
                        items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, offhandIndex + 1, victim.inventory.mainInventory.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                        break;
                    }
                    items.addAll(Arrays.asList(Arrays.copyOfRange(victim.inventory.mainInventory, InventoryPlayer.getHotbarSize() + 1, victim.inventory.mainInventory.length)).stream().filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case All: 
                case Everything: {
                    items.addAll(Arrays.stream(victim.inventory.mainInventory).filter(item -> item != null).collect(Collectors.toList()));
                    items.addAll(Arrays.stream(victim.inventory.armorInventory).filter(item -> item != null).collect(Collectors.toList()));
                    break;
                }
                case Container: {
                    Integer targetBlockPosX = null;
                    Integer targetBlockPosY = null;
                    Integer targetBlockPosZ = null;
                    TileEntity tileEntity = null;
                    IInventory tileInventory = null;
                    if (args.length >= 5 && this.isUsernameIndex(args, 0)) {
                        try {
                            targetBlockPosX = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[2], (int)victim.posX);
                            targetBlockPosY = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[3], (int)victim.posY);
                            targetBlockPosZ = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[4], (int)victim.posZ);
                        }
                        catch (Throwable t) {
                            throw new CommandException("gtnh_customizer.commands.repair.error.bad_container_position", new Object[]{String.format("%d", args[2]), String.format("%d", args[3]), String.format("%d", args[4])});
                        }
                    } else if (args.length >= 4 && this.isItemTargetIndex(args, 0)) {
                        try {
                            targetBlockPosX = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[1], (int)victim.posX);
                            targetBlockPosY = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[2], (int)victim.posY);
                            targetBlockPosZ = CommandUtils.parseBlockRelativeIntegerArgument(sender, args[3], (int)victim.posZ);
                        }
                        catch (Throwable t) {
                            throw new CommandException("gtnh_customizer.commands.repair.error.bad_container_position", new Object[]{String.format("%d", args[1]), String.format("%d", args[2]), String.format("%d", args[3])});
                        }
                    } else {
                        double reach = victim.theItemInWorldManager.getBlockReachDistance();
                        Vec3 start = Vec3.createVectorHelper((double)victim.posX, (double)(victim.posY + (double)victim.getEyeHeight()), (double)victim.posZ);
                        Vec3 look = victim.getLookVec();
                        Vec3 end = start.addVector(look.xCoord * reach, look.yCoord * reach, look.zCoord * reach);
                        MovingObjectPosition pos = victim.worldObj.func_147447_a(start, end, !Config.getRepairCommandRaycastIgnoresLiquids(), Config.getRepairCommandRaycastIgnoresLiquids(), false);
                        if (pos == null || pos.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
                            throw new WrongUsageException("gtnh_customizer.commands.repair.error.no_container", new Object[0]);
                        }
                        targetBlockPosX = pos.blockX;
                        targetBlockPosY = pos.blockY;
                        targetBlockPosZ = pos.blockZ;
                    }
                    tileEntity = victim.worldObj.getTileEntity(targetBlockPosX.intValue(), targetBlockPosY.intValue(), targetBlockPosZ.intValue());
                    if (tileEntity instanceof IInventory) {
                        tileInventory = (IInventory)tileEntity;
                    }
                    if (!(tileInventory instanceof IInventory)) {
                        throw new WrongUsageException("gtnh_customizer.commands.repair.error.no_container", new Object[0]);
                    }
                    int slotCount = tileInventory.getSizeInventory();
                    for (int i = 0; i < slotCount; ++i) {
                        ItemStack itemStack2 = tileInventory.getStackInSlot(i);
                        if (itemStack2 == null) continue;
                        items.add(itemStack2);
                    }
                    break;
                }
            }
            items.parallelStream().forEach(itemStack -> {
                NBTTagCompound stackTag;
                NBTTagCompound nBTTagCompound = stackTag = itemStack.hasTagCompound() ? itemStack.stackTagCompound : new NBTTagCompound();
                if (stackTag.hasKey("InfiTool", 10) && stackTag.getCompoundTag("InfiTool").getInteger("Damage") > 0) {
                    itemStack.setItemDamage(0);
                    if (stackTag.hasKey("RepairCost")) {
                        stackTag.removeTag("RepairCost");
                    }
                    stackTag.getCompoundTag("InfiTool").setInteger("Damage", 0);
                } else if (stackTag.hasKey("GT.ToolStats", 10) && stackTag.getCompoundTag("GT.ToolStats").getInteger("Damage") > 0) {
                    stackTag.getCompoundTag("GT.ToolStats").setInteger("Damage", 0);
                } else if (itemStack.getItem().isDamageable() && itemStack.getItemDamage() > 0) {
                    itemStack.setItemDamage(0);
                    if (stackTag.hasKey("RepairCost")) {
                        stackTag.removeTag("RepairCost");
                    }
                }
                itemStack.setTagCompound(stackTag);
            });
            sender.addChatMessage(new ChatComponentTranslation("gtnh_customizer.commands.repair.info.success", new Object[0]).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.GREEN).setItalic(Boolean.valueOf(true))));
            RepairCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"gtnh_customizer.commands.repair.info.admin_notify", (Object[])new Object[]{sender.getCommandSenderName(), String.format("%d", items.stream().mapToInt(itemStack -> itemStack.stackSize).sum())});
            return;
        }
        throw new WrongUsageException("gtnh_customizer.commands.repair.error.wrong_usage", new Object[0]);
    }

    public static enum ItemTarget {
        Hand("hand"),
        Offhand("offhand"),
        Helmet("helmet"),
        Chestplate("chestplate"),
        Leggings("leggings"),
        Boots("boots"),
        Armor("armor"),
        Hotbar("hotbar"),
        Inventory("inventory"),
        Everything("everything"),
        All("all"),
        Container("container");

        public final String commandValue;

        private ItemTarget(String commandValue) {
            this.commandValue = commandValue;
        }

        public static ItemTarget getFromCommandArgument(String argument) throws NoSuchElementException {
            return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(argument)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No ItemTarget with command value of '%s'", argument)));
        }

        @Nullable
        public static ItemTarget tryGetFromCommandArgument(String argument) {
            return Arrays.stream(ItemTarget.values()).filter(item -> item.commandValue.equalsIgnoreCase(argument)).findFirst().orElse(null);
        }
    }
}

