/*
 * Decompiled with CFR 0.152.
 */
package com.glektarssza.gtnh_customizer.mixins.early.vanilla;

import com.glektarssza.gtnh_customizer.api.immunity.ITargetingImmunity;
import com.glektarssza.gtnh_customizer.utils.ImmunityUtils;
import com.glektarssza.gtnh_customizer.utils.PlayerUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityCreature.class})
public class EntityCreatureMixin {
    @Shadow
    private Entity entityToAttack;

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideSetTarget(Entity target, CallbackInfo ci) {
        EntityCreature self;
        EntityCreature attacker = self = (EntityCreature)this;
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            ci.cancel();
        }
    }

    @Inject(method={"updateEntityActionState"}, at={@At(value="INVOKE_ASSIGN", target="net.minecraft.entity.EntityCreature.findPlayerToAttack()Lnet/minecraft/entity/Entity;")})
    public void overrideTargetedEntity(CallbackInfo ci) {
        EntityCreature self;
        EntityCreature attacker = self = (EntityCreature)this;
        Entity target = this.entityToAttack;
        if (target == null) {
            return;
        }
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        List<ITargetingImmunity> immunities = PlayerUtils.getPlayerTargetingImmunities(player);
        if (ImmunityUtils.entityMatchesAnyTargetingImmunity((EntityLivingBase)attacker, immunities) || PlayerUtils.getIsPlayerGloballyImmune(player)) {
            this.entityToAttack = null;
        }
    }
}

