/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage;

import com.mojang.logging.LogUtils;
import com.yablon.deco_storage.ModCreativeTabs;
import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.block.entities.ModBlockEntities;
import com.yablon.deco_storage.datagen.DataGenerators;
import com.yablon.deco_storage.handler.LootTableEventHandler;
import com.yablon.deco_storage.item.ModItems;
import com.yablon.deco_storage.recipe.MyRecipeSerializers;
import com.yablon.deco_storage.recipe.MyRecipeTypes;
import com.yablon.deco_storage.screen.ModMenuTypes;
import com.yablon.deco_storage.screen.StorageCrafterScreen;
import com.yablon.deco_storage.screen.StorageExtractorScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="deco_storage")
public class DecorativeStorage {
    public static final String MOD_ID = "deco_storage";
    private static final Logger LOGGER = LogUtils.getLogger();

    public DecorativeStorage(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        modEventBus.addListener(DataGenerators::onGatherData);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        MyRecipeTypes.RECIPE_TYPES.register(modEventBus);
        MyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, LootTableEventHandler::onLootTableLoad);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        RecipeManager recipeManager = event.getServer().getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_CRAFTER.get());
        List exRecipes = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_EXTRACTOR.get());
    }

    @EventBusSubscriber(modid="deco_storage", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Decorative Storage mod is init successfully");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BARREL_WITH_SLIMEBALLS.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRATE_WITH_SLIMEBALLS.get()), (RenderType)RenderType.translucent());
        }

        @SubscribeEvent
        public static void clientLoad(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.STORAGE_CRAFTER_GUI.get(), StorageCrafterScreen::new);
            event.register((MenuType)ModMenuTypes.STORAGE_EXTRACTOR_GUI.get(), StorageExtractorScreen::new);
        }
    }
}

