/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.block.blockbases;

import com.yablon.deco_storage.block.entities.HangerBlockEntity;
import com.yablon.decorative_core.block.base.AbstractDirectionalStorageBlockBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingBlockBase
extends AbstractDirectionalStorageBlockBase<HangerBlockEntity> {
    private static final VoxelShape SHAPE_NORTH_SOUTH = HangingBlockBase.box((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST_WEST = HangingBlockBase.box((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public HangingBlockBase(BlockBehaviour.Properties properties, String storedItemId) {
        super(properties, storedItemId, SHAPE_NORTH_SOUTH);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> SHAPE_EAST_WEST;
            default -> SHAPE_NORTH_SOUTH;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HangerBlockEntity(pos, state, this.getStoredItemId());
    }
}

