/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.block.entities;

import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.block.entities.BarrelBlockEntity;
import com.yablon.deco_storage.block.entities.BasketBlockEntity;
import com.yablon.deco_storage.block.entities.CrateBlockEntity;
import com.yablon.deco_storage.block.entities.HangerBlockEntity;
import com.yablon.deco_storage.block.entities.StorageCrafterBlockEntity;
import com.yablon.deco_storage.block.entities.StorageExtractorBlockEntity;
import com.yablon.deco_storage.block.entities.TrayBlockEntity;
import java.util.Arrays;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"deco_storage");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> STORAGE_CRAFTING_TABLE = ModBlockEntities.register("storage_crafting_table", ModBlocks.STORAGE_CRAFTER, StorageCrafterBlockEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> STORAGE_EXTRACTOR_BLOCK_ENTITY = ModBlockEntities.register("storage_extractor", ModBlocks.STORAGE_EXTRACTOR, StorageExtractorBlockEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BarrelBlockEntity>> BARREL_BLOCK_ENTITY = BLOCK_ENTITIES.register("barrel", () -> BlockEntityType.Builder.of((pos, state) -> new BarrelBlockEntity(pos, state, "minecraft:apple"), (Block[])ModBlockEntities.safeBlocks(new DeferredHolder[]{ModBlocks.BARREL_WITH_HAY, ModBlocks.BARREL_WITH_CARROTS, ModBlocks.BARREL_WITH_GOLDEN_CARROTS, ModBlocks.BARREL_WITH_POTATOES, ModBlocks.BARREL_WITH_POISONOUS_POTATOES, ModBlocks.BARREL_WITH_APPLES, ModBlocks.BARREL_WITH_GOLDEN_APPLES, ModBlocks.BARREL_WITH_SWEETBERRIES, ModBlocks.BARREL_WITH_GLOWBERRIES, ModBlocks.BARREL_WITH_MELONS, ModBlocks.BARREL_WITH_PUMPKINS, ModBlocks.BARREL_WITH_RAW_COPPER, ModBlocks.BARREL_WITH_RAW_IRON, ModBlocks.BARREL_WITH_RAW_GOLD, ModBlocks.BARREL_WITH_CACTUSES, ModBlocks.BARREL_WITH_SUGARCANE, ModBlocks.BARREL_WITH_AMETHYSTS, ModBlocks.BARREL_WITH_COAL, ModBlocks.BARREL_WITH_DIAMONDS, ModBlocks.BARREL_WITH_EMERALDS, ModBlocks.BARREL_WITH_QUARTZ, ModBlocks.BARREL_WITH_CHARCOAL, ModBlocks.BARREL_WITH_COD, ModBlocks.BARREL_WITH_SALMON, ModBlocks.BARREL_WITH_TROPICAL_FISH, ModBlocks.BARREL_WITH_BEETROOTS, ModBlocks.BARREL_WITH_STONE_BRICKS, ModBlocks.BARREL_WITH_BRICKS, ModBlocks.BARREL_WITH_DEEPSLATE_BRICKS, ModBlocks.BARREL_WITH_MUD_BRICKS, ModBlocks.BARREL_WITH_NETHER_BRICKS, ModBlocks.BARREL_WITH_RED_NETHER_BRICKS, ModBlocks.BARREL_WITH_POLISHED_BLACKSTONE_BRICKS, ModBlocks.BARREL_WITH_END_BRICKS, ModBlocks.BARREL_WITH_EGGS, ModBlocks.BARREL_WITH_ONIONS, ModBlocks.BARREL_WITH_CABBAGE, ModBlocks.BARREL_WITH_TOMATOES, ModBlocks.BARREL_WITH_RICE, ModBlocks.BARREL_WITH_TUFF_BRICKS, ModBlocks.BARREL_WITH_STONE, ModBlocks.BARREL_WITH_COBBLESTONE, ModBlocks.BARREL_WITH_MOSSY_COBBLESTONE, ModBlocks.BARREL_WITH_ANDESITE, ModBlocks.BARREL_WITH_GRANITE, ModBlocks.BARREL_WITH_DIORITE, ModBlocks.BARREL_WITH_IRON_NUGGETS, ModBlocks.BARREL_WITH_GOLD_NUGGETS, ModBlocks.BARREL_WITH_LAPIS_LAZULI, ModBlocks.BARREL_WITH_NETHERITE_SCRAP, ModBlocks.BARREL_WITH_RAW_ZINC, ModBlocks.BARREL_WITH_COPPER_NUGGETS, ModBlocks.BARREL_WITH_ZINC_NUGGETS, ModBlocks.BARREL_WITH_BRASS_NUGGETS, ModBlocks.CRATE_WITH_ROSE_QUARTZ, ModBlocks.BARREL_WITH_SLIMEBALLS, ModBlocks.BARREL_WITH_CLAYBALLS, ModBlocks.BARREL_WITH_ENDER_PEARLS, ModBlocks.BARREL_WITH_ENDER_EYES, ModBlocks.BARREL_WITH_FIRE_BALLS})).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TrayBlockEntity>> TRAY_BLOCK_ENTITY = BLOCK_ENTITIES.register("tray", () -> BlockEntityType.Builder.of((pos, state) -> new TrayBlockEntity(pos, state, "minecraft:apple"), (Block[])ModBlockEntities.safeBlocks(new DeferredHolder[]{ModBlocks.TRAY_WITH_RAW_GOLD, ModBlocks.TRAY_WITH_RAW_IRON, ModBlocks.TRAY_WITH_RAW_COPPER, ModBlocks.TRAY_WITH_GOLD_INGOTS, ModBlocks.TRAY_WITH_IRON_INGOTS, ModBlocks.TRAY_WITH_COPPER_INGOTS, ModBlocks.TRAY_WITH_BRICKS, ModBlocks.TRAY_WITH_DEEPSLATE_BRICKS, ModBlocks.TRAY_WITH_END_STONE_BRICKS, ModBlocks.TRAY_WITH_MUD_BRICKS, ModBlocks.TRAY_WITH_NETHER_BRICKS, ModBlocks.TRAY_WITH_RED_NETHER_BRICKS, ModBlocks.TRAY_WITH_POLISHED_BLACKSTONE_BRICKS, ModBlocks.TRAY_WITH_STONE_BRICKS, ModBlocks.TRAY_WITH_EGGS, ModBlocks.TRAY_WITH_STONE, ModBlocks.TRAY_WITH_COBBLESTONE, ModBlocks.TRAY_WITH_MOSSY_COBBLESTONE, ModBlocks.TRAY_WITH_ANDESITE, ModBlocks.TRAY_WITH_GRANITE, ModBlocks.TRAY_WITH_DIORITE, ModBlocks.TRAY_WITH_IRON_NUGGETS, ModBlocks.TRAY_WITH_GOLD_NUGGETS, ModBlocks.TRAY_WITH_LAPIS_LAZULI, ModBlocks.TRAY_WITH_NETHERITE_SCRAP, ModBlocks.TRAY_WITH_NETHERITE_INGOTS, ModBlocks.TRAY_WITH_ZINC_INGOTS, ModBlocks.TRAY_WITH_BRASS_INGOTS, ModBlocks.TRAY_WITH_ANDESITE_INGOTS, ModBlocks.TRAY_WITH_COPPER_NUGGETS, ModBlocks.TRAY_WITH_ZINC_NUGGETS, ModBlocks.TRAY_WITH_BRASS_NUGGETS})).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BasketBlockEntity>> BASKET_BLOCK_ENTITY = BLOCK_ENTITIES.register("basket", () -> BlockEntityType.Builder.of((pos, state) -> new BasketBlockEntity(pos, state, "minecraft:apple"), (Block[])ModBlockEntities.safeBlocks(new DeferredHolder[]{ModBlocks.BASKET_WITH_SALMON, ModBlocks.BASKET_WITH_TROPICAL_FISH, ModBlocks.BASKET_WITH_COOKIES, ModBlocks.BASKET_WITH_BEETROOTS, ModBlocks.BASKET_WITH_RED_MUSHROOMS, ModBlocks.BASKET_WITH_POTATOES, ModBlocks.BASKET_WITH_BROWN_MUSHROOMS, ModBlocks.BASKET_WITH_POISONOUS_POTATOES, ModBlocks.BASKET_WITH_APPLES, ModBlocks.BASKET_WITH_CARROTS, ModBlocks.BASKET_WITH_GOLDEN_CARROTS, ModBlocks.BASKET_WITH_COD, ModBlocks.BASKET_WITH_ONIONS, ModBlocks.BASKET_WITH_TOMATOES})).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<CrateBlockEntity>> CRATE_BLOCK_ENTITY = BLOCK_ENTITIES.register("crate", () -> BlockEntityType.Builder.of((pos, state) -> new CrateBlockEntity(pos, state, "minecraft:apple"), (Block[])ModBlockEntities.safeBlocks(new DeferredHolder[]{ModBlocks.CRATE_WITH_HAY, ModBlocks.CRATE_WITH_CARROTS, ModBlocks.CRATE_WITH_GOLDEN_CARROTS, ModBlocks.CRATE_WITH_POTATOES, ModBlocks.CRATE_WITH_POISONOUS_POTATOES, ModBlocks.CRATE_WITH_APPLES, ModBlocks.CRATE_WITH_GOLDEN_APPLES, ModBlocks.CRATE_WITH_SWEETBERRIES, ModBlocks.CRATE_WITH_GLOWBERRIES, ModBlocks.CRATE_WITH_MELONS, ModBlocks.CRATE_WITH_PUMPKINS, ModBlocks.CRATE_WITH_RAW_COPPER, ModBlocks.CRATE_WITH_RAW_IRON, ModBlocks.CRATE_WITH_RAW_GOLD, ModBlocks.CRATE_WITH_AMETHYSTS, ModBlocks.CRATE_WITH_COAL, ModBlocks.CRATE_WITH_DIAMONDS, ModBlocks.CRATE_WITH_EMERALDS, ModBlocks.CRATE_WITH_QUARTZ, ModBlocks.CRATE_WITH_CHARCOAL, ModBlocks.CRATE_WITH_BEETROOTS, ModBlocks.CRATE_WITH_EGGS, ModBlocks.CRATE_WITH_ONIONS, ModBlocks.CRATE_WITH_CABBAGE, ModBlocks.CRATE_WITH_TOMATOES, ModBlocks.CRATE_WITH_RICE, ModBlocks.CRATE_WITH_STONE, ModBlocks.CRATE_WITH_COBBLESTONE, ModBlocks.CRATE_WITH_MOSSY_COBBLESTONE, ModBlocks.CRATE_WITH_ANDESITE, ModBlocks.CRATE_WITH_GRANITE, ModBlocks.CRATE_WITH_DIORITE, ModBlocks.CRATE_WITH_IRON_NUGGETS, ModBlocks.CRATE_WITH_GOLD_NUGGETS, ModBlocks.CRATE_WITH_LAPIS_LAZULI, ModBlocks.CRATE_WITH_NETHERITE_SCRAP, ModBlocks.CRATE_WITH_COPPER_NUGGETS, ModBlocks.CRATE_WITH_ZINC_NUGGETS, ModBlocks.CRATE_WITH_BRASS_NUGGETS, ModBlocks.CRATE_WITH_ROSE_QUARTZ, ModBlocks.CRATE_WITH_SLIMEBALLS, ModBlocks.CRATE_WITH_CLAYBALLS, ModBlocks.CRATE_WITH_ENDER_PEARLS, ModBlocks.CRATE_WITH_ENDER_EYES, ModBlocks.CRATE_WITH_FIRE_BALLS})).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<HangerBlockEntity>> HANGER_BLOCK_ENTITY = BLOCK_ENTITIES.register("hanger", () -> BlockEntityType.Builder.of((pos, state) -> new HangerBlockEntity(pos, state, "minecraft:apple"), (Block[])ModBlockEntities.safeBlocks(new DeferredHolder[]{ModBlocks.HANGING_COD, ModBlocks.HANGING_CARROTS, ModBlocks.HANGING_GOLDEN_CARROTS, ModBlocks.HANGING_LEATHER, ModBlocks.HANGING_BEETROOTS, ModBlocks.HANGING_SALMON, ModBlocks.HANGING_TROPICAL_FISH})).build(null));

    private static DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> register(String registryname, DeferredHolder<Block, Block> block, BlockEntityType.BlockEntitySupplier<?> supplier) {
        return BLOCK_ENTITIES.register(registryname, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)block.get()}).build(null));
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)STORAGE_CRAFTING_TABLE.get(), (blockEntity, side) -> ((StorageCrafterBlockEntity)((Object)blockEntity)).getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)STORAGE_EXTRACTOR_BLOCK_ENTITY.get(), (blockEntity, side) -> ((StorageExtractorBlockEntity)((Object)blockEntity)).getItemHandler());
    }

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITIES.register(eventBus);
    }

    @SafeVarargs
    private static Block[] safeBlocks(DeferredHolder<Block, Block> ... blocks) {
        return (Block[])Arrays.stream(blocks).filter(b -> b != null).map(DeferredHolder::get).toArray(Block[]::new);
    }
}

