/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.integration.jei;

import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.recipe.StorageCrafterRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StorageCrafterRecipeCategory
implements IRecipeCategory<StorageCrafterRecipe> {
    public static final ResourceLocation UID = ResourceLocation.parse((String)"deco_storage:storage_crafter");
    public static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"deco_storage:textures/gui/storage_crafter.png");
    public static final RecipeType<StorageCrafterRecipe> STORAGE_CRAFTER_RECIPE_TYPE = new RecipeType(UID, StorageCrafterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public StorageCrafterRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.STORAGE_CRAFTER.get()));
    }

    public RecipeType<StorageCrafterRecipe> getRecipeType() {
        return STORAGE_CRAFTER_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.deco_storage.storage_crafter");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StorageCrafterRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> pattern = recipe.getGridPattern();
        for (int i = 0; i < pattern.size(); ++i) {
            int x = 58 + i % 3 * 18;
            int y = 16 + i / 3 * 18 + 1;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(pattern.get(i));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 35).addItemStack(recipe.getSingleInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 146, 35).addItemStack(recipe.getResult());
    }
}

