/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.recipe;

import com.yablon.deco_storage.recipe.MyRecipeSerializers;
import com.yablon.deco_storage.recipe.MyRecipeTypes;
import com.yablon.deco_storage.recipe.StorageCrafterInput;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class StorageCrafterRecipe
implements Recipe<StorageCrafterInput> {
    private final ItemStack singleInput;
    private final List<Ingredient> gridPattern;
    private final ItemStack result;

    public StorageCrafterRecipe(ItemStack singleInput, List<Ingredient> gridPattern, ItemStack result) {
        this.singleInput = singleInput;
        this.gridPattern = gridPattern;
        this.result = result;
    }

    public boolean matches(StorageCrafterInput input, Level level) {
        if (!ItemStack.isSameItem((ItemStack)input.getSingleInput(), (ItemStack)this.singleInput)) {
            return false;
        }
        List<ItemStack> gridItems = input.getGridItems();
        for (int i = 0; i < this.gridPattern.size(); ++i) {
            if (this.gridPattern.get(i).test(gridItems.get(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(StorageCrafterInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack getSingleInput() {
        return this.singleInput;
    }

    public List<Ingredient> getGridPattern() {
        return this.gridPattern;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public RecipeType<?> getType() {
        return MyRecipeTypes.STORAGE_CRAFTER.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return MyRecipeSerializers.STORAGE_CRAFTER.get();
    }
}

