/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.screen;

import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.block.entities.StorageExtractorBlockEntity;
import com.yablon.deco_storage.screen.ModMenuTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class StorageExtractorMenu
extends AbstractContainerMenu {
    public final StorageExtractorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final ItemStackHandler internal;
    public final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public StorageExtractorMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public StorageExtractorMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.STORAGE_EXTRACTOR_GUI.get(), pContainerId);
        StorageExtractorMenu.checkContainerSize((Container)inv, (int)3);
        this.blockEntity = (StorageExtractorBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        if (entity instanceof StorageExtractorBlockEntity) {
            StorageExtractorBlockEntity storageExtractorBlockEntity = (StorageExtractorBlockEntity)entity;
            this.internal = storageExtractorBlockEntity.getItemHandler();
        } else {
            this.internal = new ItemStackHandler(3);
        }
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.internal, 0, 80, 11){

            public boolean mayPlace(ItemStack stack) {
                return true;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.internal, 1, 80, 59){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.internal, 2, 101, 59){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        }));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0 && this.data.get(0) < this.data.get(1);
    }

    public int getScaledProgress() {
        return this.data.get(0) * 24 / 78;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.data.set(0, this.blockEntity.getProgress());
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return StorageExtractorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.STORAGE_EXTRACTOR.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

