/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.block.entities;

import com.yablon.deco_storage.block.entities.ModBlockEntities;
import com.yablon.deco_storage.recipe.StorageExtractorRecipe;
import com.yablon.deco_storage.screen.StorageExtractorMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageExtractorBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int SECOND_OUTPUT_SLOT = 2;
    private LazyOptional<IItemHandler> inputHandlerLazy = LazyOptional.empty();
    private LazyOptional<IItemHandler> outputHandlerLazy = LazyOptional.empty();
    private LazyOptional<IItemHandler> combinedHandlerLazy = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> StorageExtractorBlockEntity.this.progress;
                case 1 -> StorageExtractorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    StorageExtractorBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    StorageExtractorBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 78;

    public StorageExtractorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.STORAGE_EXTRACTOR_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.inputHandlerLazy = LazyOptional.of(() -> new InputOnlyHandler(this.itemHandler));
        this.outputHandlerLazy = LazyOptional.of(() -> new OutputOnlyHandler(this.itemHandler));
        this.combinedHandlerLazy = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inputHandlerLazy.orElseThrow(IllegalStateException::new), (IItemHandlerModifiable)this.outputHandlerLazy.orElseThrow(IllegalStateException::new)}));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputHandlerLazy.invalidate();
        this.outputHandlerLazy.invalidate();
        this.combinedHandlerLazy.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.combinedHandlerLazy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.tutorialmod.gem_polishing_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new StorageExtractorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("storage_crafter.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("storage_crafter.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            StorageExtractorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<StorageExtractorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack firstResult = recipe.get().getFirstOutput();
        ItemStack secondResult = recipe.get().getSecondOutput();
        float bonusChance = recipe.get().getBonusChance();
        this.itemHandler.extractItem(0, 1, false);
        ItemStack out1 = this.itemHandler.getStackInSlot(1);
        int newCount1 = out1.m_41613_() + firstResult.m_41613_();
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)firstResult.m_41720_(), newCount1));
        int add = secondResult.m_41613_();
        if (Math.random() < (double)bonusChance) {
            ++add;
        }
        ItemStack out2 = this.itemHandler.getStackInSlot(2);
        int newCount2 = out2.m_41613_() + add;
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)secondResult.m_41720_(), newCount2));
    }

    private boolean hasRecipe() {
        Optional<StorageExtractorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack firstResult = recipe.get().getFirstOutput();
        ItemStack secondResult = recipe.get().getSecondOutput();
        return this.canInsertAmountIntoOutputSlot(1, firstResult.m_41613_()) && this.canInsertItemIntoOutputSlot(1, firstResult.m_41720_()) && this.canInsertAmountIntoOutputSlot(2, secondResult.m_41613_()) && this.canInsertItemIntoOutputSlot(2, secondResult.m_41720_());
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        return stack.m_41619_() || stack.m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        return stack.m_41613_() + count <= stack.m_41741_();
    }

    private Optional<StorageExtractorRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)StorageExtractorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private static class OutputOnlyHandler
    extends RangedWrapper {
        public OutputOnlyHandler(ItemStackHandler handler) {
            super((IItemHandlerModifiable)handler, 1, 3);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }
    }

    private static class InputOnlyHandler
    extends RangedWrapper {
        public InputOnlyHandler(ItemStackHandler handler) {
            super((IItemHandlerModifiable)handler, 0, 1);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    }
}

