/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage;

import com.mojang.logging.LogUtils;
import com.yablon.deco_storage.Config;
import com.yablon.deco_storage.ModCreativeModeTabs;
import com.yablon.deco_storage.block.ModBlocks;
import com.yablon.deco_storage.block.entities.ModBlockEntities;
import com.yablon.deco_storage.item.ModItems;
import com.yablon.deco_storage.recipe.ModRecipes;
import com.yablon.deco_storage.screen.ModMenuTypes;
import com.yablon.deco_storage.screen.StorageCrafterScreen;
import com.yablon.deco_storage.screen.StorageExtractorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="deco_storage")
public class DecoStorageMod {
    public static final String MOD_ID = "deco_storage";
    public static final Logger LOGGER = LogUtils.getLogger();

    public DecoStorageMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="deco_storage", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STORAGE_CRAFTER_MENU.get()), StorageCrafterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STORAGE_EXTRACTOR_MENU.get()), StorageExtractorScreen::new);
        }
    }
}

