/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StorageCrafterRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> pattern;
    private final ItemStack input;
    private final ItemStack result;

    public StorageCrafterRecipe(ResourceLocation id, NonNullList<Ingredient> pattern, ItemStack input, ItemStack result) {
        this.id = id;
        this.pattern = pattern;
        this.input = input;
        this.result = result;
    }

    public boolean matches(SimpleContainer container, Level level) {
        for (int i = 0; i < this.pattern.size(); ++i) {
            ItemStack stackInSlot = container.m_8020_(i);
            if (!(this.pattern.get(i) == Ingredient.f_43901_ ? !stackInSlot.m_41619_() : !((Ingredient)this.pattern.get(i)).test(stackInSlot))) continue;
            return false;
        }
        return container.m_8020_(9).m_150930_(this.input.m_41720_());
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.pattern.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> getPattern() {
        return this.pattern;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<StorageCrafterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("deco_storage", "storage_crafter");

        public StorageCrafterRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            NonNullList pattern = NonNullList.m_122779_();
            jsonObject.getAsJsonArray("pattern").forEach(element -> {
                if (element.isJsonNull() || "minecraft:air".equals(element.getAsJsonObject().get("item").getAsString())) {
                    pattern.add((Object)Ingredient.f_43901_);
                } else {
                    pattern.add((Object)Ingredient.m_43917_((JsonElement)element));
                }
            });
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("result"));
            return new StorageCrafterRecipe(resourceLocation, (NonNullList<Ingredient>)pattern, input, result);
        }

        @Nullable
        public StorageCrafterRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            NonNullList pattern = NonNullList.m_122779_();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                pattern.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack input = buffer.m_130267_();
            ItemStack result = buffer.m_130267_();
            return new StorageCrafterRecipe(resourceLocation, (NonNullList<Ingredient>)pattern, input, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, StorageCrafterRecipe recipe) {
            buffer.writeInt(recipe.getPattern().size());
            for (Ingredient ingredient : recipe.getPattern()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.getInput());
            buffer.m_130055_(recipe.getResult());
        }
    }

    public static class Type
    implements RecipeType<StorageCrafterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "storage_crafter";

        private Type() {
        }

        public String toString() {
            return ID;
        }
    }
}

