/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.decorations.polydex;

import de.tomalbrc.decorations.carpentry.CarpentryRecipe;
import de.tomalbrc.decorations.polydex.CarpentryPage;
import de.tomalbrc.filament.decoration.DecorationItem;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class PolydexCompat {
    public static final PolydexCategory CATEGORY = PolydexCategory.of((class_2960)class_2960.method_60655((String)"tsa", (String)"carpentry"));
    public static final Map<class_2960, RecipeInfo> INFO_MAP = new Object2ObjectOpenHashMap();

    public static void init(MinecraftServer server) {
        List recipes = server.method_3772().method_30027((class_3956)CarpentryRecipe.Type.INSTANCE);
        for (class_8786 recipe : recipes) {
            class_1799 res = ((CarpentryRecipe)recipe.comp_1933()).method_8110((class_7225.class_7874)server.method_30611());
            class_1792 class_17922 = res.method_7909();
            if (!(class_17922 instanceof DecorationItem)) continue;
            DecorationItem decorationItem = (DecorationItem)class_17922;
            PolydexCompat.add(decorationItem);
            ArrayList ingredients = new ArrayList();
            ingredients.add(PolydexIngredient.of((class_1856)((CarpentryRecipe)recipe.comp_1933()).getBaseIngredient()));
            ingredients.add(PolydexIngredient.of((class_1856)((CarpentryRecipe)recipe.comp_1933()).getIngredient()));
            ((CarpentryRecipe)recipe.comp_1933()).getTrimIngredient().ifPresent(val -> ingredients.add(PolydexIngredient.of((class_1856)val)));
            INFO_MAP.put(decorationItem.getDecorationData().id(), new RecipeInfo(res, ingredients));
        }
        PolydexPage.register(PolydexCompat::createPages);
    }

    public static void add(DecorationItem item) {
        PolydexEntry.registerEntryCreator((class_1792)item, PolydexCompat::createEntries);
    }

    private static PolydexEntry createEntries(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof DecorationItem)) {
            return PolydexEntry.of((class_1799)stack);
        }
        DecorationItem decorationItem = (DecorationItem)class_17922;
        return PolydexEntry.of((class_2960)decorationItem.getDecorationData().id(), (class_1799)stack);
    }

    private static void createPages(MinecraftServer server, Consumer<PolydexPage> pageConsumer) {
        for (RecipeInfo val : INFO_MAP.values()) {
            class_1792 class_17922 = val.itemStack.method_7909();
            if (!(class_17922 instanceof DecorationItem)) continue;
            DecorationItem decorationItem = (DecorationItem)class_17922;
            pageConsumer.accept(new CarpentryPage(decorationItem.getDecorationData()));
        }
    }

    public record RecipeInfo(class_1799 itemStack, List<PolydexIngredient<?>> ingredients) {
    }
}

