/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.decorations.carpentry;

import de.tomalbrc.decorations.carpentry.CarpentryInputSlot;
import de.tomalbrc.decorations.carpentry.CarpentryRecipe;
import de.tomalbrc.decorations.carpentry.CarpentryResultSlot;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3917;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CarpentryGui
extends SimpleGui {
    private final class_1277 container;
    private final CarpentryInputSlot baseSlot;
    private final CarpentryInputSlot slot;
    private final CarpentryInputSlot trimSlot;
    private final CarpentryResultSlot resultSlot;
    private int scrollIndex = 0;
    private int selX = 0;
    private int selY = -1;
    @Nullable
    private CarpentryRecipe selectedRecipe;
    private static final int WIDTH = 4;
    private static final int HEIGHT = 6;
    private Runnable closeCB = null;

    private String buildGuiTitle(int column, int row, float percentage) {
        column = 3 - column;
        String colA = "(".repeat(column);
        String colB = ")".repeat(column);
        String rowStr = row < 6 && row >= 0 ? Character.toString(0xF700 | row) : "___>";
        String scrollStr = percentage == -1.0f ? "\uf000" : Character.toString(0xF800 | (int)(28.0f * percentage));
        return String.format("<color:#ffffff><font:tsadecorations:ui><U<xx----%s%s%s____--%s<<xxxxxxxxx</font></color><lang:block.tsa.carpentry_table>", colA, rowStr, colB, scrollStr);
    }

    private void updateTitle(int column, int row, List<CarpentryRecipe> recipes) {
        int rows = (int)Math.ceil(recipes.size() / 4);
        int hidden = rows - 5;
        float scrollProgress = Math.min(1.0f, Math.max(0.0f, (float)this.scrollIndex / (float)hidden));
        String str = this.buildGuiTitle(column, row, hidden <= 0 ? -1.0f : scrollProgress);
        this.setTitle(TextParserUtils.formatText((String)str));
    }

    public CarpentryGui(class_3917<?> type, class_3222 player, boolean manipulatePlayerSlots) {
        super(type, player, manipulatePlayerSlots);
        this.updateTitle(this.selX, this.selY, List.of());
        this.container = this.getSimpleContainer();
        this.baseSlot = new CarpentryInputSlot((class_1263)this.container, 0, 0, 0, this::updateEx);
        this.slot = new CarpentryInputSlot((class_1263)this.container, 1, 0, 0, this::updateEx);
        this.trimSlot = new CarpentryInputSlot((class_1263)this.container, 2, 0, 0, this::updateEx);
        this.resultSlot = new CarpentryResultSlot((class_1263)this.container, 3, 0, 0, this::consumeCallback);
        BiFunction<Integer, Integer, Integer> f = (x, y) -> x + y * 9;
        this.setSlotRedirect(f.apply(0, 1), this.baseSlot);
        this.setSlotRedirect(f.apply(1, 1), this.slot);
        this.setSlotRedirect(f.apply(2, 1), this.trimSlot);
        this.setSlotRedirect(f.apply(1, 4), this.resultSlot);
        this.setSlot(f.apply(8, 0), class_1799.field_8037, (x, y, clickType) -> {
            int newIndex = Math.max(0, this.scrollIndex - 1);
            if (this.scrollIndex != newIndex) {
                this.scrollIndex = newIndex;
                ++this.selY;
                this.updateItemList(this.availableRecipes());
            }
        });
        this.setSlot(f.apply(8, 5), class_1799.field_8037, (x, y, clickType) -> {
            List<CarpentryRecipe> items = this.availableRecipes();
            if (items.size() - this.scrollIndex * 4 > 24) {
                ++this.scrollIndex;
                --this.selY;
                this.updateItemList(items);
            }
        });
    }

    private List<CarpentryRecipe> availableRecipes() {
        ObjectArrayList list = new ObjectArrayList();
        class_9694 input = class_9694.method_59986((int)3, (int)1, List.of(this.container.method_5438(0), this.container.method_5438(1), this.container.method_5438(2)));
        List<class_8786> recipes = this.player.method_51469().method_8503().method_3772().method_8126().stream().filter(x -> {
            CarpentryRecipe carpentryRecipe;
            class_1860 patt0$temp = x.comp_1933();
            return patt0$temp instanceof CarpentryRecipe && (carpentryRecipe = (CarpentryRecipe)patt0$temp).matches(input, (class_1937)this.player.method_51469());
        }).map(x -> x).toList();
        for (class_8786 recipe : recipes) {
            class_1799 res = ((CarpentryRecipe)recipe.comp_1933()).getResult();
            if (res == null || res.method_7960()) continue;
            list.add((CarpentryRecipe)recipe.comp_1933());
        }
        return list;
    }

    private void updateItemList(List<CarpentryRecipe> recipes) {
        if (this.selectedRecipe != null && !recipes.contains(this.selectedRecipe)) {
            this.resultSlot.method_7673(class_1799.field_8037);
            this.selX = 0;
            this.selY = -1;
            this.scrollIndex = 0;
        }
        this.updateTitle(this.selX, this.selY, recipes);
        int start = 4;
        int offset = this.scrollIndex * 4;
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 4; ++row) {
                int index = row + column * 4 + offset;
                int index2 = row + column * 9;
                if (index < recipes.size()) {
                    CarpentryRecipe recipe = recipes.get(index);
                    class_1799 item = recipe.getResult();
                    int finalColumn = column;
                    int finalRow = row;
                    this.setSlot(4 + index2, item.method_7972(), (x, y, clickType) -> {
                        this.selX = finalRow;
                        this.selY = finalColumn;
                        this.updateTitle(finalRow, finalColumn, recipes);
                        this.selectedRecipe = recipe;
                        this.resultSlot.method_7673(item.method_7972());
                    });
                    continue;
                }
                this.setSlot(4 + index2, class_1799.field_8037);
            }
        }
    }

    public void onClose() {
        this.player.method_31548().method_7398(this.player.field_7512.method_34255());
        this.player.field_7512.method_34254(class_1799.field_8037);
        for (int i = 0; i < this.container.method_5439() - 1; ++i) {
            if (this.container.method_5438(i).method_7960()) continue;
            this.player.method_31548().method_7398(this.container.method_5441(i));
        }
        this.container.method_24514();
        if (this.closeCB != null) {
            this.closeCB.run();
        }
    }

    public boolean open(Runnable runnable) {
        this.closeCB = runnable;
        return this.open();
    }

    @NotNull
    private class_1277 getSimpleContainer() {
        return new class_1277(4);
    }

    public class_1799 quickMove(int index) {
        class_1799 res = super.quickMove(index);
        if (index == this.resultSlot.field_7874) {
            this.consumeCallback(res);
        }
        return res;
    }

    public void consumeCallback(class_1799 itemStack) {
        this.player.method_7342(class_3468.field_15370.method_14956((Object)itemStack.method_7909()), itemStack.method_7947());
        this.baseSlot.method_7677().method_7934(1);
        this.slot.method_7677().method_7934(1);
        this.trimSlot.method_7677().method_7934(1);
        List<CarpentryRecipe> l = this.availableRecipes();
        this.updateResultSlot(l);
        this.updateItemList(l);
    }

    private void updateEx() {
        List<CarpentryRecipe> l = this.availableRecipes();
        this.updateResultSlot(l);
        this.updateItemList(l);
        this.updateTitle(this.selX, this.selY, l);
    }

    private void updateResultSlot(List<CarpentryRecipe> available) {
        if (this.selectedRecipe == null) {
            return;
        }
        if (available.contains(this.selectedRecipe)) {
            this.resultSlot.method_7673(this.selectedRecipe.getResult().method_7972());
        }
        this.updateItemList(available);
    }
}

