/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.decorations.polydex;

import de.tomalbrc.decorations.polydex.PolydexCompat;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.DecorationItem;
import de.tomalbrc.filament.registry.ItemGroupRegistry;
import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.impl.book.InternalPageTextures;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CarpentryPage
implements PolydexPage {
    public static final class_1799 TYPE_ICON = new GuiElementBuilder((class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"tsa", (String)"carpentry_table"))).setName((class_2561)class_2561.method_43471((String)"polydex.tsa.carpentry.recipes").method_27692(class_124.field_1065)).asStack();
    private List<PolydexIngredient<?>> ingredients;
    private final DecorationData decorationData;

    public CarpentryPage(DecorationData decorationData) {
        this.decorationData = decorationData;
        this.ingredients = PolydexCompat.INFO_MAP.get(decorationData.id()).ingredients();
    }

    @Nullable
    public class_2561 texture(class_3222 player) {
        return InternalPageTextures.SMITHING;
    }

    public class_2960 identifier() {
        return this.decorationData.id();
    }

    public class_1799 typeIcon(class_3222 serverPlayerEntity) {
        return ((class_1792)class_7923.field_41178.method_10223(this.decorationData.id())).method_7854();
    }

    public class_1799 entryIcon(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity) {
        return ((class_1761)ItemGroupRegistry.TAB_GROUPS.get((Object)this.decorationData.itemGroup())).method_7747();
    }

    public void createPage(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity, PageBuilder layer) {
        if (polydexEntry == null) {
            return;
        }
        int i = 0;
        this.ingredients = PolydexCompat.INFO_MAP.get(polydexEntry.identifier()).ingredients();
        layer.set(4, 0, TYPE_ICON);
        for (PolydexIngredient<?> ingredient : this.ingredients) {
            layer.setIngredient(i + 2, 2, ingredient);
            if (++i != 3) continue;
            break;
        }
        layer.setOutput(6, 2, new class_1799[]{((class_1792)class_7923.field_41178.method_10223(polydexEntry.identifier())).method_7854()});
    }

    public List<PolydexIngredient<?>> ingredients() {
        return this.ingredients;
    }

    public List<PolydexCategory> categories() {
        return List.of(PolydexCompat.CATEGORY);
    }

    public boolean isOwner(MinecraftServer minecraftServer, PolydexEntry polydexEntry) {
        class_1799 itemStack = (class_1799)polydexEntry.stack().getBacking();
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof DecorationItem) {
            DecorationItem decorationItem = (DecorationItem)class_17922;
            return Objects.equals(decorationItem.getDecorationData().itemGroup(), this.decorationData.itemGroup());
        }
        return false;
    }
}

