/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9062;
import net.satisfy.lilis_lucky_lures.core.block.FishNetFenceBlock;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlock
extends class_2237 {
    public static final class_2746 FULL = class_2746.method_11825((String)"full");
    public static final class_2746 HAS_BAIT = class_2746.method_11825((String)"has_bait");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 HANGING = class_2746.method_11825((String)"hanging");
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_6862<class_2248> ROPES = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)LilisLuckyLuresIdentifier.identifier("ropes"));
    private static final class_265 SHAPE_NORMAL = class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static final class_265 SHAPE_HANGING = class_259.method_1081((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375);
    public static final MapCodec<FishTrapBlock> CODEC = FishTrapBlock.method_54094(FishTrapBlock::new);

    public FishTrapBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FULL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_BAIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FULL, HAS_BAIT, WATERLOGGED, HANGING, FACING});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        boolean hanging = this.isHanging((class_1936)level, pos.method_10084());
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(pos).method_15772() == class_3612.field_15910))).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11036) {
            boolean hanging = this.isHanging(level, pos.method_10084());
            return (class_2680)state.method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(hanging));
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (fromPos.equals((Object)pos.method_10084())) {
            boolean hanging = this.isHanging((class_1936)level, pos.method_10084());
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(hanging)), 3);
        }
        super.method_9612(state, level, pos, block, fromPos, isMoving);
    }

    private boolean isHanging(class_1936 level, class_2338 pos) {
        class_2680 aboveState = level.method_8320(pos);
        return aboveState.method_26164(ROPES) || aboveState.method_26204() instanceof FishNetFenceBlock;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, @NotNull class_3726 context) {
        return (Boolean)state.method_11654((class_2769)HANGING) != false ? SHAPE_HANGING : SHAPE_NORMAL;
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FishTrapBlockEntity(pos, state);
    }

    @NotNull
    protected class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand != class_1268.field_5808) {
            return class_9062.field_47731;
        }
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof FishTrapBlockEntity)) {
            return class_9062.field_47731;
        }
        FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)be;
        class_1799 inHand = player.method_5998(hand);
        if (!inHand.method_7960()) {
            if (!level.field_9236 && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && fishTrap.method_5438(0).method_7960()) {
                class_1799 one = inHand.method_7972();
                one.method_7939(1);
                fishTrap.method_5447(0, one);
                if (!player.method_31549().field_7477) {
                    inHand.method_7934(1);
                }
                fishTrap.method_5431();
                level.method_8524(pos);
                this.updateBlockState(level, pos, !fishTrap.method_5438(1).method_7960(), !fishTrap.method_5438(0).method_7960());
                return class_9062.field_47728;
            }
            return class_9062.field_47729;
        }
        if (!level.field_9236) {
            class_1799 output = fishTrap.method_5438(1);
            if (!output.method_7960()) {
                int n = output.method_7947();
                class_1799 give = output.method_7972();
                if (!player.method_7270(give)) {
                    class_1542 e = new class_1542(level, player.method_23317(), player.method_23318(), player.method_23321(), give);
                    level.method_8649((class_1297)e);
                }
                fishTrap.method_5434(1, n);
                fishTrap.method_5431();
                level.method_8524(pos);
                this.updateBlockState(level, pos, !fishTrap.method_5438(1).method_7960(), !fishTrap.method_5438(0).method_7960());
                return class_9062.field_47728;
            }
            class_1799 bait = fishTrap.method_5438(0);
            if (!bait.method_7960()) {
                int n = bait.method_7947();
                class_1799 give = bait.method_7972();
                if (!player.method_7270(give)) {
                    class_1542 e = new class_1542(level, player.method_23317(), player.method_23318(), player.method_23321(), give);
                    level.method_8649((class_1297)e);
                }
                fishTrap.method_5434(0, n);
                fishTrap.method_5431();
                level.method_8524(pos);
                this.updateBlockState(level, pos, !fishTrap.method_5438(1).method_7960(), !fishTrap.method_5438(0).method_7960());
                return class_9062.field_47728;
            }
        }
        return class_9062.field_47731;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 ? null : FishTrapBlock.method_31618(blockEntityType, (class_2591)((class_2591)EntityTypeRegistry.FISH_TRAP.get()), (lvl, pos, blkState, blockEntity) -> blockEntity.tick());
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
        if (((Boolean)state.method_11654((class_2769)FULL)).booleanValue() && random.method_43057() < 0.1f) {
            double x = (double)pos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 0.5;
            double y = (double)pos.method_10264() + 0.7 + random.method_43058() * 0.3;
            double z = (double)pos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 0.5;
            level.method_8406((class_2394)class_2398.field_11238, x, y, z, 0.0, 0.02, 0.0);
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        if (level.field_9236 && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            int particleCount = 10;
            double centerX = (double)pos.method_10263() + 0.5;
            double centerZ = (double)pos.method_10260() + 0.5;
            double centerY = (double)pos.method_10264() + 0.1;
            double velocity = 0.05;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double radius = 0.15;
                for (int j = 0; j < 3; ++j) {
                    double x = centerX + radius * Math.cos(angle);
                    double z = centerZ + radius * Math.sin(angle);
                    double y = centerY + (double)j * 0.1;
                    double velX = Math.cos(angle) * velocity;
                    double velZ = Math.sin(angle) * velocity;
                    double velY = 0.02 + (double)j * 0.01;
                    level.method_8406((class_2394)class_2398.field_11247, x, y, z, velX, velY, velZ);
                    radius += 0.4;
                }
            }
        }
    }

    public void updateBlockState(class_1937 level, class_2338 pos, boolean full, boolean hasBait) {
        class_2680 newState;
        class_2680 state = level.method_8320(pos);
        if (!state.equals(newState = (class_2680)((class_2680)state.method_11657((class_2769)FULL, (Comparable)Boolean.valueOf(full))).method_11657((class_2769)HAS_BAIT, (Comparable)Boolean.valueOf(hasBait)))) {
            level.method_8652(pos, newState, 11);
        } else {
            level.method_8413(pos, state, newState, 11);
        }
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity;
        if (!state.method_27852(newState.method_26204()) && (blockEntity = level.method_8321(pos)) instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity fishTrap = (FishTrapBlockEntity)blockEntity;
            for (int i = 0; i < fishTrap.method_5439(); ++i) {
                class_1799 stack = fishTrap.method_5438(i);
                if (stack.method_7960()) continue;
                class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
            }
            level.method_8544(pos);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }
}

