/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import net.satisfy.lilis_lucky_lures.core.block.entity.HangingFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingFrameBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<class_2756> HALF = class_2754.method_11850((String)"half", class_2756.class);
    private static final class_265 TOP_SHAPE = class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1073(), (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)0.875, (double)0.5625), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.0, (double)0.875, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.125, (double)0.625, (double)0.4375, (double)0.875, (double)0.875, (double)0.5625), (class_247)class_247.field_1366);
    private static final class_265 BOTTOM_SHAPE = class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1072((class_265)class_259.method_1073(), (class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.4375, (double)0.125, (double)0.625, (double)0.5625), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.875, (double)0.125, (double)0.4375, (double)1.0, (double)0.625, (double)0.5625), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.3125, (double)0.125, (double)0.125, (double)0.6875), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.3125, (double)1.0, (double)0.125, (double)0.6875), (class_247)class_247.field_1366), (class_265)class_259.method_1081((double)0.0, (double)0.625, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (class_247)class_247.field_1366);
    private static final Map<class_2350, class_265> TOP_SHAPES = new HashMap<class_2350, class_265>();
    private static final Map<class_2350, class_265> BOTTOM_SHAPES = new HashMap<class_2350, class_265>();

    public HangingFrameBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, HALF});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 posAbove = ctx.method_8037().method_10084();
        class_1937 level = ctx.method_8045();
        if (!level.method_8320(posAbove).method_26166(ctx)) {
            return null;
        }
        class_2680 baseState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(HALF, (Comparable)class_2756.field_12607);
        level.method_8652(posAbove, (class_2680)baseState.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        return baseState;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2338 otherPos;
            class_2680 otherState;
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof HangingFrameBlockEntity) {
                HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
                for (class_1799 stack : shelfBlockEntity.getInventory()) {
                    if (stack.method_7960()) continue;
                    class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
                }
                level.method_8544(pos);
            }
            if ((otherState = level.method_8320(otherPos = state.method_11654(HALF) == class_2756.field_12607 ? pos.method_10084() : pos.method_10074())).method_27852((class_2248)this)) {
                level.method_8652(otherPos, class_2246.field_10124.method_9564(), 35);
            }
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (direction == class_2350.field_11033 && half == class_2756.field_12609 && neighborState.method_26204() != this) {
            return class_2246.field_10124.method_9564();
        }
        if (direction == class_2350.field_11036 && half == class_2756.field_12607 && neighborState.method_26204() != this) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return state.method_11654(HALF) == class_2756.field_12609 ? TOP_SHAPES.get(state.method_11654((class_2769)FACING)) : BOTTOM_SHAPES.get(state.method_11654((class_2769)FACING));
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HangingFrameBlockEntity(pos, state, this.size());
    }

    public int size() {
        return 3;
    }

    protected class_9062 method_55765(class_1799 item, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof HangingFrameBlockEntity)) {
            return class_9062.field_47731;
        }
        HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
        Optional<class_3545<Float, Float>> optional = LilisLuckyLuresUtil.getRelativeHitCoordinatesForBlockFace(hit, (class_2350)state.method_11654((class_2769)FACING), new class_2350[]{class_2350.field_11033, class_2350.field_11036});
        if (optional.isEmpty()) {
            return class_9062.field_47731;
        }
        int i = 2 - (int)(((Float)optional.get().method_15442()).floatValue() * 3.0f);
        if (i < 0 || i >= shelfBlockEntity.getInventory().size()) {
            return class_9062.field_47731;
        }
        if (!((class_1799)shelfBlockEntity.getInventory().get(i)).method_7960()) {
            if (!world.field_9236) {
                class_1799 itemStack = shelfBlockEntity.removeStack(i);
                world.method_8396(null, pos, class_3417.field_15226, class_3419.field_15245, 1.0f, 1.0f);
                if (!player.method_31548().method_7394(itemStack)) {
                    player.method_7328(itemStack, false);
                }
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            }
            return class_9062.method_55644((boolean)world.field_9236);
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && stack.method_31573(class_3489.field_15527)) {
            if (!world.field_9236) {
                shelfBlockEntity.setStack(i, stack.method_7971(1));
                world.method_8396(null, pos, class_3417.field_14628, class_3419.field_15245, 1.0f, 1.0f);
                if (player.method_7337()) {
                    stack.method_7933(1);
                }
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            }
            return class_9062.method_55644((boolean)world.field_9236);
        }
        return class_9062.field_47729;
    }

    static {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            TOP_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(class_2350.field_11043, direction, TOP_SHAPE));
            BOTTOM_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(class_2350.field_11043, direction, BOTTOM_SHAPE));
        }
    }
}

