/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3829;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.lilis_lucky_lures.core.block.FishTrapBlock;
import net.satisfy.lilis_lucky_lures.core.recipe.FishTrapRecipe;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrapBlockEntity
extends class_2586
implements class_1278,
class_3829 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private int timer = 0;
    private int duration = 0;
    private boolean processing = false;
    private FishTrapRecipe recipe;

    public FishTrapBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.FISH_TRAP.get(), pos, state);
    }

    public void tick() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_1799 inputItem = (class_1799)this.inventory.get(0);
            if (this.recipe == null && !inputItem.method_7960()) {
                FishTrapBlockEntity.getRecipe(this.field_11863, inputItem).ifPresent(currentRecipe -> {
                    this.recipe = currentRecipe;
                });
            }
            if (this.recipe == null || inputItem.method_7960()) {
                this.processing = false;
                this.timer = 0;
                return;
            }
            if (this.processing) {
                ++this.timer;
                if (this.timer >= this.duration) {
                    this.processing = false;
                    this.timer = 0;
                    class_1799 stack = (class_1799)this.inventory.get(0);
                    if (!stack.method_7960()) {
                        stack.method_7934(1);
                        if (stack.method_7947() <= 0) {
                            this.inventory.set(0, (Object)class_1799.field_8037);
                        }
                    }
                    this.addCatchToOutput();
                    this.recipe = null;
                    this.method_5431();
                }
            } else if (this.recipe.getBaitItem().method_8093(inputItem)) {
                this.processing = true;
                this.duration = this.recipe.getRandomDuration();
            }
            this.updateBlockState();
        }
    }

    private void addCatchToOutput() {
        class_1799 output = this.recipe.getCatchItem().method_7972();
        output.method_7939(this.recipe.getCatchCount());
        class_1799 existingOutput = (class_1799)this.inventory.get(1);
        if (existingOutput.method_7960()) {
            this.inventory.set(1, (Object)output);
        } else if (class_1799.method_31577((class_1799)existingOutput, (class_1799)output)) {
            existingOutput.method_7933(output.method_7947());
            this.inventory.set(1, (Object)existingOutput);
        }
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.field_11863 != null) {
            boolean isFull = !((class_1799)this.inventory.get(1)).method_7960();
            boolean hasBait = !((class_1799)this.inventory.get(0)).method_7960();
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof FishTrapBlock) {
                FishTrapBlock fishTrapBlock = (FishTrapBlock)class_22482;
                fishTrapBlock.updateBlockState(this.field_11863, this.field_11867, isFull, hasBait);
            }
        }
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        class_1262.method_5429((class_2487)compoundTag, this.inventory, (class_7225.class_7874)provider);
        this.timer = compoundTag.method_10550("Timer");
        this.duration = compoundTag.method_10550("Duration");
        this.processing = compoundTag.method_10577("Processing");
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        class_1262.method_5426((class_2487)compoundTag, this.inventory, (class_7225.class_7874)provider);
        compoundTag.method_10569("Timer", this.timer);
        compoundTag.method_10569("Duration", this.duration);
        compoundTag.method_10556("Processing", this.processing);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)provider);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        class_1799 removed = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        this.method_5431();
        this.updateBlockState();
        return removed;
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        class_1799 removed = class_1262.method_5428(this.inventory, (int)slot);
        this.method_5431();
        this.updateBlockState();
        return removed;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
        this.updateBlockState();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
        this.recipe = null;
        this.method_5431();
        this.updateBlockState();
    }

    public int @NotNull [] method_5494(class_2350 direction) {
        return new int[]{0, 1};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return slot == 0 && this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        return slot == 1;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return this.field_11863 != null && FishTrapBlockEntity.getRecipe(this.field_11863, stack).isPresent();
        }
        return false;
    }

    public static Optional<FishTrapRecipe> getRecipe(class_1937 level, class_1799 itemStack) {
        return level.method_8433().method_30027((class_3956)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get()).stream().map(class_8786::comp_1933).filter(r -> r.getBaitItem().method_8093(itemStack)).findFirst();
    }
}

