/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.satisfy.lilis_lucky_lures.core.block.RedstoneCoilBlock;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class RedstoneCoilBlockEntity
extends class_2586 {
    private static final Random RANDOM = new Random();
    private class_2338 targetPos = null;
    private int beamProgress = 0;
    private int tickCounter = 0;
    private int phase = 0;
    private UUID owner = null;

    public RedstoneCoilBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.REDSTONE_COIL.get(), pos, state);
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        if (this.owner != null) {
            compoundTag.method_25927("Owner", this.owner);
        }
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        if (compoundTag.method_25928("Owner")) {
            this.owner = compoundTag.method_25926("Owner");
        }
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setActive(boolean active) {
        if (this.field_11863 != null) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)RedstoneCoilBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, RedstoneCoilBlockEntity be) {
        class_3218 serverLevel;
        block33: {
            block32: {
                if (!(level instanceof class_3218)) break block32;
                serverLevel = (class_3218)level;
                if (((Boolean)state.method_11654((class_2769)RedstoneCoilBlock.ACTIVE)).booleanValue()) break block33;
            }
            return;
        }
        ++be.tickCounter;
        if (be.tickCounter >= 200) {
            be.tickCounter = 0;
            int range = Math.min(32, Math.max(3, serverLevel.method_49804(pos)));
            class_238 box = new class_238(pos).method_1014((double)range);
            List entities = serverLevel.method_8390(class_1309.class, box, class_1309::method_5805);
            RedstoneCoilBlock.RedstoneCoilTarget targetMode = (RedstoneCoilBlock.RedstoneCoilTarget)((Object)state.method_11654(RedstoneCoilBlock.TARGET));
            ArrayList<class_1309> filtered = new ArrayList<class_1309>();
            switch (targetMode) {
                case NONE: {
                    break;
                }
                case FISHES: {
                    for (class_1309 entity : entities) {
                        if (!entity.method_5799()) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case PLAYER: {
                    Iterator ownerPlayer = be.owner != null ? serverLevel.method_18470(be.owner) : null;
                    for (class_1309 entity : entities) {
                        class_1657 p;
                        if (!(entity instanceof class_1657) || (p = (class_1657)entity).method_7337() || ownerPlayer != null && (p.method_5667().equals(ownerPlayer.method_5667()) || ownerPlayer.method_5781() != null && p.method_5781() != null && ownerPlayer.method_5781().method_1206((class_270)p.method_5781()))) continue;
                        filtered.add(entity);
                    }
                    break;
                }
                case MONSTER: {
                    for (class_1309 entity : entities) {
                        if (entity.method_5864().method_5891() != class_1311.field_6302) continue;
                        filtered.add(entity);
                    }
                    break;
                }
            }
            if (!filtered.isEmpty()) {
                class_1309 target = (class_1309)filtered.get(0);
                be.targetPos = target.method_24515();
                be.beamProgress = 0;
                be.phase = 1;
                serverLevel.method_8396(null, pos, class_3417.field_14908, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        if (be.phase == 1 && be.beamProgress < 30) {
            double radius = (1.0 - (double)be.beamProgress / 30.0) * 2.0;
            for (int i = 0; i < 5; ++i) {
                double angle = serverLevel.field_9229.method_43058() * Math.PI * 2.0;
                double x = (double)pos.method_10263() + 0.5 + radius * Math.cos(angle);
                double y = (double)pos.method_10264() + 1.0 + serverLevel.field_9229.method_43058();
                double z = (double)pos.method_10260() + 0.5 + radius * Math.sin(angle);
                serverLevel.method_14199((class_2394)class_2398.field_29644, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ++be.beamProgress;
            if (be.beamProgress >= 30) {
                be.beamProgress = 0;
                be.phase = 2;
            }
        }
        if (be.phase == 2 && be.beamProgress < 20 && be.targetPos != null) {
            if (be.beamProgress == 0) {
                serverLevel.method_8396(null, pos, class_3417.field_15231, class_3419.field_15245, 1.0f, 1.0f);
            }
            ++be.beamProgress;
            double progress = (double)be.beamProgress / 20.0;
            Vector3d start = new Vector3d((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5);
            Vector3d end = new Vector3d((double)be.targetPos.method_10263() + 0.5, (double)be.targetPos.method_10264() + 0.5, (double)be.targetPos.method_10260() + 0.5);
            Vector3d dir = new Vector3d((Vector3dc)end).sub((Vector3dc)start);
            Vector3d current = new Vector3d((Vector3dc)dir).mul(progress).add((Vector3dc)start);
            Vector3d arbitrary = new Vector3d(0.0, 1.0, 0.0);
            if (Math.abs(dir.dot((Vector3dc)arbitrary)) > 0.99) {
                arbitrary.set(1.0, 0.0, 0.0);
            }
            Vector3d perp = new Vector3d();
            dir.cross((Vector3dc)arbitrary, perp).normalize();
            double wave = Math.sin(progress * Math.PI * 4.0) * 0.1;
            perp.mul(wave);
            current.add((Vector3dc)perp);
            serverLevel.method_14199((class_2394)class_2398.field_11207, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.method_14199((class_2394)class_2398.field_29644, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.method_14199((class_2394)class_2398.field_11251, current.x, current.y, current.z, 1, 0.0, 0.0, 0.0, 0.0);
            if (be.beamProgress >= 20) {
                List targets = serverLevel.method_8390(class_1309.class, new class_238(be.targetPos).method_1014(1.0), class_1309::method_5805);
                if (!targets.isEmpty()) {
                    class_1657 player;
                    class_1309 livingTarget = (class_1309)targets.get(0);
                    if (livingTarget instanceof class_1657 && (player = (class_1657)livingTarget).method_6039()) {
                        boolean offShield;
                        boolean mainShield = !player.method_6047().method_7960() && player.method_6047().method_7909() instanceof class_1819;
                        boolean bl = offShield = !player.method_6079().method_7960() && player.method_6079().method_7909() instanceof class_1819;
                        if (mainShield || offShield) {
                            Vector3d shieldPos;
                            class_1268 hand;
                            class_1799 shieldStack;
                            if (mainShield) {
                                shieldStack = player.method_6047();
                                hand = class_1268.field_5808;
                            } else {
                                shieldStack = player.method_6079();
                                hand = class_1268.field_5810;
                            }
                            int shieldDamage = serverLevel.field_9229.method_43048(10) + 4;
                            shieldStack.method_7970(shieldDamage, (class_1309)player, player.method_32326(shieldStack));
                            Vector3d look = new Vector3d(player.method_5720().field_1352, player.method_5720().field_1351, player.method_5720().field_1350);
                            Vector3d right = new Vector3d();
                            new Vector3d(0.0, 1.0, 0.0).cross((Vector3dc)look, right).normalize();
                            if (hand == class_1268.field_5808) {
                                shieldPos = new Vector3d(player.method_23317(), player.method_23318() + (double)player.method_5751() - 0.5, player.method_23321());
                                shieldPos.add((Vector3dc)look.mul(0.3)).add((Vector3dc)right.mul(0.4));
                            } else {
                                shieldPos = new Vector3d(player.method_23317(), player.method_23318() + (double)player.method_5751() - 0.5, player.method_23321());
                                shieldPos.add((Vector3dc)look.mul(0.3)).sub((Vector3dc)right.mul(0.4));
                            }
                            int flashCount = serverLevel.field_9229.method_43048(2) + 2;
                            for (int i = 0; i < flashCount; ++i) {
                                double flashX = shieldPos.x + (serverLevel.field_9229.method_43058() - 0.5) * 0.2;
                                double flashY = shieldPos.y + (serverLevel.field_9229.method_43058() - 0.5) * 0.2;
                                double flashZ = shieldPos.z + (serverLevel.field_9229.method_43058() - 0.5) * 0.2;
                                serverLevel.method_14199((class_2394)class_2398.field_17909, flashX, flashY, flashZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            for (class_1309 entity : serverLevel.method_8390(class_1309.class, new class_238(shieldPos.x, shieldPos.y, shieldPos.z, shieldPos.x, shieldPos.y, shieldPos.z).method_1014(10.0), class_1309::method_5805)) {
                                entity.method_6092(new class_1293(class_1294.field_5919, 60, 0));
                            }
                        } else {
                            RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                        }
                    } else {
                        RedstoneCoilBlockEntity.applyDamage(livingTarget, serverLevel, be);
                    }
                }
                be.phase = 0;
                be.targetPos = null;
                be.beamProgress = 0;
            }
        }
    }

    private static void applyDamage(class_1309 livingTarget, class_3218 serverLevel, RedstoneCoilBlockEntity be) {
        float damage = 10.0f;
        if (livingTarget.method_5799()) {
            damage *= 1.65f;
        }
        boolean hasIronArmor = false;
        for (class_1304 slot : class_1304.values()) {
            class_1738 armorItem;
            class_1792 class_17922;
            class_1799 armorStack;
            if (slot.method_5925() != class_1304.class_1305.field_6178 || (armorStack = livingTarget.method_6118(slot)).method_7960() || !((class_17922 = armorStack.method_7909()) instanceof class_1738) || (armorItem = (class_1738)class_17922).method_7686() != class_1740.field_7892) continue;
            hasIronArmor = true;
            int armorDamage = serverLevel.field_9229.method_43048(5) + 3;
            armorStack.method_7970(armorDamage, livingTarget, slot);
        }
        if (hasIronArmor) {
            damage *= 1.12f;
        }
        livingTarget.method_5643(serverLevel.method_48963().method_48831(), damage);
        livingTarget.method_56073(5);
        RedstoneCoilBlockEntity.setFireAround(serverLevel, be.targetPos);
        RedstoneCoilBlockEntity.spawnImpactParticles(serverLevel, be.targetPos);
    }

    private static void setFireAround(class_3218 level, class_2338 center) {
        for (int x = center.method_10263() - 3; x <= center.method_10263() + 3; ++x) {
            for (int y = center.method_10264() - 3; y <= center.method_10264() + 3; ++y) {
                for (int z = center.method_10260() - 3; z <= center.method_10260() + 3; ++z) {
                    class_2338 currentPos = new class_2338(x, y, z);
                    class_2338 abovePos = currentPos.method_10084();
                    if (level.method_8320(currentPos).method_26215() || !level.method_22347(abovePos) || !(RANDOM.nextDouble() < 0.05)) continue;
                    level.method_8652(abovePos, class_2246.field_10036.method_9564(), 3);
                }
            }
        }
    }

    private static void spawnImpactParticles(class_3218 level, class_2338 pos) {
        for (int i = 0; i < 40; ++i) {
            Vector3d vec = new Vector3d(level.field_9229.method_43058() * 2.0 - 1.0, level.field_9229.method_43058() * 2.0 - 1.0, level.field_9229.method_43058() * 2.0 - 1.0);
            if (vec.lengthSquared() == 0.0) continue;
            vec.normalize().mul(level.field_9229.method_43058() * 1.5 + 0.5);
            double particleX = (double)pos.method_10263() + 0.5;
            double particleY = (double)pos.method_10264() + 0.5;
            double particleZ = (double)pos.method_10260() + 0.5;
            level.method_14199((class_2394)class_2398.field_11251, particleX, particleY, particleZ, 0, vec.x, vec.y, vec.z, 0.2);
            level.method_14199((class_2394)class_2398.field_11240, particleX, particleY, particleZ, 0, vec.x * 1.2, vec.y * 1.2, vec.z * 1.2, 0.1);
        }
    }
}

