/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FloatingDebrisEntity
extends class_1297 {
    private static final int MAX_INTERACTIONS = 3;
    private static final float DESTRUCTION_SPEED = 0.05f;
    private static final class_2940<Boolean> IS_DESTROYING = class_2945.method_12791(FloatingDebrisEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DESTRUCTION_PROGRESS = class_2945.method_12791(FloatingDebrisEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> HURT_TIME = class_2945.method_12791(FloatingDebrisEntity.class, (class_2941)class_2943.field_13327);
    private final float randomRotation;
    private int interactions = 0;
    private int lifeTicks;
    private int maxLifeTicks;

    public FloatingDebrisEntity(class_1299<? extends FloatingDebrisEntity> type, class_1937 level) {
        super(type, level);
        Random random = new Random();
        this.method_5857(this.method_5829().method_989(0.0, 1.0, 0.0));
        this.randomRotation = random.nextFloat() * 360.0f;
        this.lifeTicks = 0;
        this.maxLifeTicks = 9600;
        if (!this.method_37908().field_9236) {
            this.spawnPlacementParticles();
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(IS_DESTROYING, (Object)false);
        builder.method_56912(DESTRUCTION_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(HURT_TIME, (Object)0);
    }

    public void method_5773() {
        int currentHurtTime;
        super.method_5773();
        if (!this.method_37908().field_9236) {
            ++this.lifeTicks;
            if (this.lifeTicks >= this.maxLifeTicks) {
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
        }
        if (this.method_37908().field_9236 && this.lifeTicks % 120 == 0) {
            this.spawnPeriodicParticles();
        }
        if ((currentHurtTime = ((Integer)this.field_6011.method_12789(HURT_TIME)).intValue()) > 0) {
            this.field_6011.method_12778(HURT_TIME, (Object)(currentHurtTime - 1));
        }
        if (!this.method_37908().field_9236 && !this.isAboveWater()) {
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        if (((Boolean)this.field_6011.method_12789(IS_DESTROYING)).booleanValue()) {
            float currentProgress = ((Float)this.field_6011.method_12789(DESTRUCTION_PROGRESS)).floatValue();
            this.field_6011.method_12778(DESTRUCTION_PROGRESS, (Object)Float.valueOf(currentProgress += 0.05f));
            if (currentProgress >= 1.0f) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    public float getRandomRotation() {
        return this.randomRotation;
    }

    private boolean isAboveWater() {
        return this.method_37908().method_8320(this.method_24515().method_10074()).method_26227().method_15771();
    }

    protected void method_5749(class_2487 compound) {
        this.interactions = compound.method_10550("Interactions");
        boolean destroying = compound.method_10577("IsDestroying");
        float progress = compound.method_10583("DestructionProgress");
        this.field_6011.method_12778(IS_DESTROYING, (Object)destroying);
        this.field_6011.method_12778(DESTRUCTION_PROGRESS, (Object)Float.valueOf(progress));
        this.field_6011.method_12778(HURT_TIME, (Object)compound.method_10550("HurtTime"));
        this.lifeTicks = compound.method_10550("LifeTicks");
        this.maxLifeTicks = compound.method_10550("MaxLifeTicks");
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("Interactions", this.interactions);
        compound.method_10556("IsDestroying", ((Boolean)this.field_6011.method_12789(IS_DESTROYING)).booleanValue());
        compound.method_10548("DestructionProgress", ((Float)this.field_6011.method_12789(DESTRUCTION_PROGRESS)).floatValue());
        compound.method_10569("HurtTime", ((Integer)this.field_6011.method_12789(HURT_TIME)).intValue());
        compound.method_10569("LifeTicks", this.lifeTicks);
        compound.method_10569("MaxLifeTicks", this.maxLifeTicks);
    }

    public void triggerHurt() {
        this.field_6011.method_12778(HURT_TIME, (Object)10);
        if (!this.method_37908().field_9236) {
            this.maxLifeTicks += 2400;
        }
    }

    public class_52 getLootTable(class_3218 serverLevel) {
        return serverLevel.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)LilisLuckyLuresIdentifier.identifier("gameplay/fishing_pools/floating_debris")));
    }

    public void onFishHookInteract(class_1657 player) {
        class_1937 class_19372;
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_52 lootTable = this.getLootTable(serverLevel);
            class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1230, (Object)player).method_51874(class_181.field_1231, (Object)serverLevel.method_48963().method_48830()).method_51875(class_173.field_1173);
            ObjectArrayList loot = lootTable.method_51878(lootParams);
            loot.forEach(arg_0 -> ((class_1657)player).method_7270(arg_0));
            this.triggerHurt();
            ++this.interactions;
            if (this.interactions >= 3) {
                this.removeWithEffects(serverLevel);
            }
        }
    }

    public void removeWithEffects(class_3218 serverLevel) {
        double zOffset;
        int i;
        serverLevel.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_39026, class_3419.field_15245, 1.0f, 1.0f);
        for (i = 0; i < 35; ++i) {
            double yOffset = serverLevel.field_9229.method_43058() * 15.0;
            double xOffset = 0.25 * (serverLevel.field_9229.method_43058() - 0.5);
            zOffset = 0.25 * (serverLevel.field_9229.method_43058() - 0.5);
            double velocityY = 0.1 + serverLevel.field_9229.method_43058() * 0.2;
            serverLevel.method_14199((class_2394)class_2398.field_11202, this.method_23317() + xOffset + 0.5, this.method_23318() + yOffset, this.method_23321() + zOffset + 0.5, 1, 0.0, velocityY, 0.0, 0.0);
        }
        for (i = 0; i < 18; ++i) {
            double xOffset = serverLevel.field_9229.method_43059() * 0.2;
            double yOffset = serverLevel.field_9229.method_43059() * 0.2;
            zOffset = serverLevel.field_9229.method_43059() * 0.2;
            serverLevel.method_14199((class_2394)class_2398.field_11241, this.method_23317(), this.method_23318(), this.method_23321(), 20, xOffset, yOffset, zOffset, 0.1);
            serverLevel.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 10, xOffset, yOffset, zOffset, 0.1);
            serverLevel.method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(), 5, xOffset, yOffset, zOffset, 0.1);
        }
        this.field_6011.method_12778(IS_DESTROYING, (Object)true);
    }

    public int getHurtTime() {
        return (Integer)this.field_6011.method_12789(HURT_TIME);
    }

    public void triggerInteraction() {
        ++this.interactions;
        this.triggerHurt();
        if (this.interactions >= 3 && !this.method_37908().field_9236) {
            this.removeWithEffects((class_3218)this.method_37908());
        }
    }

    private void spawnPlacementParticles() {
        for (int i = 0; i < 10; ++i) {
            double xOffset = this.field_5974.method_43058() - 0.5;
            double zOffset = this.field_5974.method_43058() - 0.5;
            this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317() + xOffset, this.method_23318() + 1.9, this.method_23321() + zOffset, 0.0, 0.1, 0.0);
        }
    }

    private void spawnPeriodicParticles() {
        double x = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0;
        double z = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0;
        this.method_37908().method_8406((class_2394)class_2398.field_11202, x, this.method_23318() + 1.8, z, 0.0, 0.05, 0.0);
    }

    @NotNull
    public class_238 method_5830() {
        return new class_238(this.method_23317() - 1.0, this.method_23318() - 1.0, this.method_23321() - 1.0, this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0);
    }
}

