/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FishingNetItem
extends class_1792 {
    private static final float SUCCESS_CHANCE = 0.8f;
    private static final int USE_DURATION = 100;
    private static final int COOLDOWN_TICKS = 40;
    private static final String TAG_STATE = "State";
    private static final String TAG_ENTITY_LOOT = "EntityLoot";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_FULL = 1;

    public FishingNetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        int state = this.getState(stack);
        if (state == 0) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        if (!level.field_9236) {
            this.retrieveLoot(level, player, stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseTicks) {
        if (!level.field_9236 && entity instanceof class_1657) {
            FloatingDebrisEntity targetDebris;
            class_1657 player = (class_1657)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                class_3218 serverLevel = (class_3218)level;
                this.spawnParticles(serverLevel, targetDebris.method_23317(), targetDebris.method_23318() + 0.5, targetDebris.method_23321());
                if (remainingUseTicks % 20 == 0) {
                    level.method_43128(null, targetDebris.method_23317(), targetDebris.method_23318(), targetDebris.method_23321(), class_3417.field_15171, class_3419.field_15254, 1.25f, 1.0f);
                }
            }
        }
    }

    @NotNull
    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        if (!level.field_9236 && entity instanceof class_1657) {
            FloatingDebrisEntity targetDebris;
            class_1657 player = (class_1657)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                if (level.method_8409().method_43057() <= 0.8f) {
                    this.setState(stack, 1);
                    class_52 entityLootTable = targetDebris.getLootTable((class_3218)level);
                    class_8567 lootParams = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51875(class_173.field_16235);
                    ObjectArrayList entityLoot = entityLootTable.method_51878(lootParams);
                    class_2499 lootListTag = new class_2499();
                    for (class_1799 item : entityLoot) {
                        lootListTag.add((Object)item.method_57358((class_7225.class_7874)level.method_30349()));
                    }
                    class_9279 data = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
                    data = data.method_57451(tag -> tag.method_10566(TAG_ENTITY_LOOT, (class_2520)lootListTag));
                    stack.method_57379(class_9334.field_49628, (Object)data);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14818, class_3419.field_15248, 1.0f, 1.0f);
                    targetDebris.triggerInteraction();
                } else {
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14737, class_3419.field_15248, 0.5f, 0.8f);
                }
                player.method_7357().method_7906((class_1792)this, 40);
            }
        }
        return stack;
    }

    private void retrieveLoot(class_1937 level, class_1657 player, class_1799 stack) {
        class_3218 serverLevel = (class_3218)level;
        class_52 fishingNetLootTable = serverLevel.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)LilisLuckyLuresIdentifier.identifier("gameplay/fishing_net")));
        class_8567 fishingNetLootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51875(class_173.field_16235);
        ObjectArrayList fishingNetLoot = fishingNetLootTable.method_51878(fishingNetLootParams);
        fishingNetLoot.forEach(arg_0 -> ((class_1657)player).method_7270(arg_0));
        class_9279 data = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = data.method_57461();
        if (!tag.method_33133() && tag.method_10573(TAG_ENTITY_LOOT, 9)) {
            class_2499 lootListTag = tag.method_10554(TAG_ENTITY_LOOT, 10);
            for (int i = 0; i < lootListTag.size(); ++i) {
                class_2487 itemTag = lootListTag.method_10602(i);
                class_1799 entityLootItem = class_1799.method_57360((class_7225.class_7874)level.method_30349(), (class_2520)itemTag).orElseGet(() -> class_1799.field_8037);
                if (entityLootItem.method_7960()) continue;
                player.method_7270(entityLootItem);
            }
            data = data.method_57451(t -> t.method_10551(TAG_ENTITY_LOOT));
            stack.method_57379(class_9334.field_49628, (Object)data);
        }
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
        this.setState(stack, 0);
    }

    private int getState(class_1799 stack) {
        class_9279 data = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        if (data.method_57458()) {
            return 0;
        }
        class_2487 tag = data.method_57461();
        return tag.method_10545(TAG_STATE) ? tag.method_10550(TAG_STATE) : 0;
    }

    private void setState(class_1799 stack, int state) {
        class_9279 data = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        data = data.method_57451(tag -> tag.method_10569(TAG_STATE, state));
        if (state == 1) {
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(1));
        } else {
            stack.method_57381(class_9334.field_49637);
        }
        stack.method_57379(class_9334.field_49628, (Object)data);
    }

    private FloatingDebrisEntity getTargetDebris(class_1937 level, class_1657 player) {
        List debris = level.method_18467(FloatingDebrisEntity.class, player.method_5829().method_1014(1.0));
        return debris.stream().filter(entity -> this.isInSight(player, (FloatingDebrisEntity)((Object)entity))).min(Comparator.comparingDouble(arg_0 -> ((class_1657)player).method_5739(arg_0))).orElse(null);
    }

    private boolean isInSight(class_1657 player, FloatingDebrisEntity entity) {
        class_243 toEntity;
        class_243 lookVec = player.method_5720();
        double dot = lookVec.method_1026(toEntity = entity.method_19538().method_1020(player.method_33571()).method_1029());
        return dot > 0.7;
    }

    private void spawnParticles(class_3218 serverLevel, double x, double y, double z) {
        class_5819 random = serverLevel.method_8409();
        for (int i = 0; i < 15; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 1.5;
            double offsetY = random.method_43058() + 0.5;
            double offsetZ = (random.method_43058() - 0.5) * 1.5;
            serverLevel.method_14199((class_2394)class_2398.field_11247, x + offsetX, y + offsetY, z + offsetZ, 2, 0.0, 0.05, 0.0, 0.01);
        }
    }

    public int method_7881(class_1799 itemStack, class_1309 livingEntity) {
        return 100;
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_42717;
    }
}

