/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.util;

import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.RiverFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;

public class FloatingPoolsSpawner {
    private static final int MAX_COUNT = 3;
    private static final int SPAWN_INTERVAL = 6000;
    private static class_2338 lastValidSpawn = null;
    private static long lastSpawnTime = 0L;

    private static void attemptSpawn(class_3218 level) {
        if (level.method_18456().isEmpty()) {
            return;
        }
        class_5819 random = level.field_9229;
        class_3222 player = (class_3222)level.method_18456().get(random.method_43048(level.method_18456().size()));
        if (lastValidSpawn == null || level.method_8510() - lastSpawnTime > 12000L) {
            lastValidSpawn = FloatingPoolsSpawner.findValidSpawnPos(level, player.method_24515());
            lastSpawnTime = level.method_8510();
        }
        if (lastValidSpawn == null) {
            return;
        }
        int spawnX = lastValidSpawn.method_10263();
        int spawnY = lastValidSpawn.method_10264();
        int spawnZ = lastValidSpawn.method_10260();
        class_238 area = new class_238((double)(spawnX - 128), (double)(spawnY - 128), (double)(spawnZ - 128), (double)(spawnX + 128), (double)(spawnY + 128), (double)(spawnZ + 128));
        int totalCount = level.method_18467(FloatingDebrisEntity.class, area).size();
        totalCount += level.method_18467(FloatingBooksEntity.class, area).size();
        class_6880 biome = level.method_23753(lastValidSpawn);
        if (biome.method_40220(class_6908.field_36509)) {
            totalCount += level.method_18467(OceanFishPoolEntity.class, area).size();
        } else if (biome.method_40220(class_6908.field_36511)) {
            totalCount += level.method_18467(RiverFishPoolEntity.class, area).size();
        }
        if (totalCount >= 3) {
            return;
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        class_238 smallArea = new class_238((double)(spawnX - 50), (double)(spawnY - 50), (double)(spawnZ - 50), (double)(spawnX + 50), (double)(spawnY + 50), (double)(spawnZ + 50));
        if (level.method_18467(FloatingDebrisEntity.class, smallArea).size() < 3) {
            actions.add(() -> {
                FloatingDebrisEntity debris = new FloatingDebrisEntity((class_1299<? extends FloatingDebrisEntity>)((class_1299)EntityTypeRegistry.FLOATING_DEBRIS.get()), (class_1937)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                debris.method_5814(spawnPos.x, spawnPos.y, spawnPos.z);
                level.method_8649((class_1297)debris);
            });
        }
        if (biome.method_40220(class_6908.field_36509)) {
            actions.add(() -> {
                OceanFishPoolEntity ocean = new OceanFishPoolEntity((class_1299<? extends OceanFishPoolEntity>)((class_1299)EntityTypeRegistry.OCEAN_FISH_POOL.get()), (class_1937)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                ocean.method_5814(spawnPos.x, spawnPos.y, spawnPos.z);
                level.method_8649((class_1297)ocean);
            });
        } else if (biome.method_40220(class_6908.field_36511)) {
            actions.add(() -> {
                RiverFishPoolEntity river = new RiverFishPoolEntity((class_1299<? extends RiverFishPoolEntity>)((class_1299)EntityTypeRegistry.RIVER_FISH_POOL.get()), (class_1937)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                river.method_5814(spawnPos.x, spawnPos.y, spawnPos.z);
                level.method_8649((class_1297)river);
            });
        }
        actions.add(() -> {
            FloatingBooksEntity books = new FloatingBooksEntity((class_1299<? extends FloatingBooksEntity>)((class_1299)EntityTypeRegistry.FLOATING_BOOKS.get()), (class_1937)level);
            Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
            books.method_5814(spawnPos.x, spawnPos.y, spawnPos.z);
            level.method_8649((class_1297)books);
        });
        ((Runnable)actions.get(random.method_43048(actions.size()))).run();
    }

    private static class_2338 findValidSpawnPos(class_3218 level, class_2338 center) {
        class_5819 random = level.field_9229;
        for (int i = 0; i < 10; ++i) {
            int offsetZ;
            int offsetX = random.method_43048(200) - 100;
            class_2338 newPos = center.method_10069(offsetX, 0, offsetZ = random.method_43048(200) - 100);
            class_6880 biome = level.method_23753(newPos);
            if (!biome.method_40220(class_6908.field_36511) && !biome.method_40220(class_6908.field_36509)) continue;
            int spawnY = level.method_8624(class_2902.class_2903.field_13202, newPos.method_10263(), newPos.method_10260()) - 2;
            return new class_2338(newPos.method_10263(), spawnY, newPos.method_10260());
        }
        return null;
    }

    public static void tick(class_3218 level) {
        if (level.method_8510() % 6000L == 0L) {
            FloatingPoolsSpawner.attemptSpawn(level);
        }
    }
}

