/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.Optional;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.command.CraftingTweaksCommand;
import net.blay09.mods.craftingtweaks.compat.VanillaCraftingGridProvider;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.crafting.ShapedRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.crafting.ShapelessRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.network.HelloMessage;
import net.blay09.mods.craftingtweaks.network.ModNetworking;
import net.blay09.mods.craftingtweaks.registry.ConfigJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.LegacyJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.ModFileJsonCompatLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import net.minecraft.class_8710;
import net.minecraft.class_9695;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaks {
    public static final String MOD_ID = "craftingtweaks";
    public static boolean debugMode;
    public static final Logger logger;
    public static boolean isServerSideInstalled;

    public static void initialize(BalmRegistrars registrars) {
        CraftingTweaksConfig.initialize();
        ModNetworking.initialize(Balm.networking());
        Balm.commands().register(CraftingTweaksCommand::register);
        registrars.resourceReloadListeners(registrar -> registrar.register("json_registry", (class_3302)new LegacyJsonCompatLoader()));
        CraftingTweaksAPI.registerCraftingGridProvider(new VanillaCraftingGridProvider());
        CraftingTweaksAPI.registerRecipeMapper(class_1869.class, new ShapedRecipeMatrixMapper());
        CraftingTweaksAPI.registerRecipeMapper(class_1867.class, new ShapelessRecipeMatrixMapper());
        ServerPlayerCallback.Join.EVENT.register(player -> Balm.networking().sendTo((class_1657)player, (class_8710)HelloMessage.INSTANCE));
        ItemCallback.Craft.After.EVENT.register((player, itemStack, craftMatrix) -> {
            class_1937 level = player.method_73183();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_1863 recipeManager = serverLevel.method_8503().method_3772();
                    if (craftMatrix instanceof class_8566) {
                        class_8566 craftingContainer = (class_8566)craftMatrix;
                        Optional optionalRecipeHolder = recipeManager.method_8132(class_3956.field_17545, (class_9695)craftingContainer.method_59961(), level);
                        optionalRecipeHolder.ifPresent(recipeHolder -> CraftingTweaksAPI.setLastCraftedRecipe(serverPlayer, recipeHolder));
                    }
                }
            }
        });
        Balm.config().onConfigAvailable(CraftingTweaksConfig.class, config -> {
            ModFileJsonCompatLoader.load();
            ConfigJsonCompatLoader.load();
        });
    }

    static {
        logger = LoggerFactory.getLogger(CraftingTweaks.class);
        isServerSideInstalled = true;
    }
}

