/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.gui.screens.BalmScreenUtils;
import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.InternalClientMethodsImpl;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksDebugger;
import net.blay09.mods.craftingtweaks.client.ModKeyMappings;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.network.CraftStackMessage;
import net.blay09.mods.craftingtweaks.network.TransferStackMessage;
import net.blay09.mods.kuma.api.Kuma;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.lwjgl.glfw.GLFW;

public class CraftingTweaksClient {
    private static final ClientProvider clientProvider = new ClientProvider();
    private static boolean ignoreMouseUp;
    private static int rightClickCraftingSlot;
    private static class_339 unpleasantButton;
    private static int fixedUnpleasantButtonX;

    public static void initialize(BalmClientRegistrars registrars) {
        CraftingTweaksClientAPI.setupAPI(new InternalClientMethodsImpl());
        CraftingTweaksClientAPI.registerCraftingGridGuiHandler(class_465.class, new DefaultGridGuiHandler());
        ModKeyMappings.initialize();
        ItemCallback.Craft.After.EVENT.register(CraftingTweaksClient::onItemCrafted);
        ClientLifecycleCallback.ConnectedToServer.EVENT.register(client -> {
            CraftingTweaks.isServerSideInstalled = false;
        });
        ScreenCallback.Init.After.EVENT.register(CraftingTweaksClient::screenInitialized);
        ScreenCallback.KeyPress.After.EVENT.register(CraftingTweaksClient::screenKeyPressed);
        ScreenCallback.MousePress.Before.EVENT.register(CraftingTweaksClient::screenMouseClick);
        ScreenCallback.MouseRelease.Before.EVENT.register(CraftingTweaksClient::screenMouseRelease);
        ScreenCallback.Render.BEFORE.register(CraftingTweaksClient::screenAboutToDraw);
        ScreenCallback.Render.AFTER.register(CraftingTweaksClient::screenDrawn);
        CraftingTweaksDebugger.initialize();
    }

    public static boolean screenKeyPressed(class_437 screen, class_11908 event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_1041 window = class_310.method_1551().method_22683();
            if (CraftingTweaks.isServerSideInstalled && GLFW.glfwGetKey((long)window.method_4490(), (int)66) == 1 && GLFW.glfwGetKey((long)window.method_4490(), (int)76) == 1 && GLFW.glfwGetKey((long)window.method_4490(), (int)65) == 1 && (GLFW.glfwGetKey((long)window.method_4490(), (int)89) == 1 || GLFW.glfwGetKey((long)window.method_4490(), (int)90) == 1)) {
                CraftingTweaks.isServerSideInstalled = false;
                player.method_7353((class_2561)class_2561.method_43470((String)"[CraftingTweaks] Enabled client-side testing mode"), false);
                return true;
            }
        }
        return false;
    }

    public static boolean screenMouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    public static boolean screenMouseClick(class_437 screen, class_11909 event) {
        rightClickCraftingSlot = -1;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return false;
        }
        class_1735 mouseSlot = screen instanceof class_465 ? ((AbstractContainerScreenAccessor)screen).getHoveredSlot() : null;
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (grid != null) {
            if (ModKeyMappings.keyTransferStack.isActiveAndDown()) {
                if (mouseSlot != null && mouseSlot.method_7681()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (Kuma.hasShiftDown()) {
                        class_1799 mouseSlotStack = mouseSlot.method_7677();
                        for (class_1735 slot : menu.field_7761) {
                            class_1799 slotStack;
                            if (!slot.method_7681() || mouseSlot == slot || !class_1799.method_31577((class_1799)(slotStack = slot.method_7677()), (class_1799)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (class_1735 slot : transferSlots) {
                            Balm.networking().sendToServer((class_8710)new TransferStackMessage(grid.getId(), slot.field_7874));
                        }
                    } else {
                        for (class_1735 slot : transferSlots) {
                            clientProvider.transferIntoGrid((class_1657)player, menu, grid, slot);
                        }
                        ignoreMouseUp = true;
                    }
                    return true;
                }
            } else if (CraftingTweaksConfig.getActive().client.rightClickCraftsStack && event.method_74233() && mouseSlot instanceof class_1734) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.networking().sendToServer((class_8710)new CraftStackMessage(mouseSlot.field_7874));
                } else {
                    rightClickCraftingSlot = mouseSlot.field_7874;
                }
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    public static void screenInitialized(class_437 screen) {
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            GridGuiHandler guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen);
            unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler);
            if (unpleasantButton != null) {
                fixedUnpleasantButtonX = unpleasantButton.method_46426();
            }
            List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(containerScreen.method_17577());
            for (CraftingGrid grid : grids) {
                String modId = grid.getId().method_12836();
                CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
                if (config != CraftingTweaksMode.DEFAULT && config != CraftingTweaksMode.BUTTONS) continue;
                guiHandler.createButtons(containerScreen, grid, widget -> BalmScreenUtils.addRenderableWidget((class_437)screen, (class_364)widget));
            }
        }
    }

    private static void handleRightClickCrafting() {
        if (rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = rightClickCraftingSlot;
        rightClickCraftingSlot = -1;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_636 playerController = class_310.method_1551().field_1761;
        if (playerController == null) {
            return;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return;
        }
        if (craftingSlot >= menu.field_7761.size()) {
            return;
        }
        class_1735 mouseSlot = (class_1735)menu.field_7761.get(craftingSlot);
        if (!mouseSlot.method_7681()) {
            rightClickCraftingSlot = mouseSlot.field_7874;
            return;
        }
        class_1799 mouseStack = menu.method_34255();
        if (mouseStack.method_7960() || mouseStack.method_7947() + mouseSlot.method_7677().method_7947() <= mouseStack.method_7914()) {
            playerController.method_2906(menu.field_7763, mouseSlot.field_7874, 0, class_1713.field_7790, (class_1657)player);
            rightClickCraftingSlot = mouseSlot.field_7874;
        }
    }

    public static void screenAboutToDraw(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (screen instanceof class_465) {
            GridGuiHandler guiHandler;
            int unpleasantX;
            class_465 containerScreen = (class_465)screen;
            if (unpleasantButton != null && (unpleasantX = unpleasantButton.method_46426()) != fixedUnpleasantButtonX && (unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen))) != null) {
                fixedUnpleasantButtonX = unpleasantButton.method_46426();
            }
        }
    }

    public static void screenDrawn(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        CraftingTweaksClient.handleRightClickCrafting();
    }

    private static void onItemCrafted(class_1657 player, class_1799 itemStack, class_1263 craftMatrix) {
        clientProvider.onItemCrafted(craftMatrix);
    }

    public static ClientProvider getClientProvider() {
        return clientProvider;
    }

    static {
        rightClickCraftingSlot = -1;
    }
}

