/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.minecraft.class_11909;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaksDebugger {
    private static final Logger logger = LoggerFactory.getLogger(CraftingTweaksDebugger.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final class_768 currentMenuLabelRect = new class_768(0, 0, 0, 0);
    private static class_2561 currentMenuLabel;
    private static class_1735 startDragSlot;
    private static class_1735 endDragSlot;

    public static void initialize() {
        ScreenCallback.Init.After.EVENT.register(screen -> {
            if (!CraftingTweaks.debugMode) {
                return;
            }
            if (CraftingTweaks.debugMode && screen instanceof class_465) {
                class_465 containerScreen = (class_465)screen;
                class_1703 menu = containerScreen.method_17577();
                String modId = CraftingTweaksDebugger.getModId(menu);
                CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), 1, 9);
                currentMenuLabel = class_2561.method_43470((String)menu.getClass().getName());
                int labelWidth = class_310.method_1551().field_1772.method_27525((class_5348)currentMenuLabel);
                currentMenuLabelRect.method_35778(((AbstractContainerScreenAccessor)screen).getLeftPos() + ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2 - labelWidth / 2);
                currentMenuLabelRect.method_35781(((AbstractContainerScreenAccessor)screen).getTopPos() - 20);
                currentMenuLabelRect.method_35782(labelWidth);
                currentMenuLabelRect.method_35783(16);
            }
        });
        ScreenCallback.MouseRelease.Before.EVENT.register(CraftingTweaksDebugger::onMouseRelease);
        ScreenCallback.MousePress.Before.EVENT.register(CraftingTweaksDebugger::onMouseClick);
        ScreenCallback.Render.AFTER_BACKGROUND.register(CraftingTweaksDebugger::onScreenDrawn);
    }

    public static void onScreenDrawn(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        AbstractContainerScreenAccessor accessor;
        if (!CraftingTweaks.debugMode) {
            return;
        }
        if (startDragSlot != null && screen instanceof AbstractContainerScreenAccessor && (endDragSlot = (accessor = (AbstractContainerScreenAccessor)screen).getHoveredSlot()) != null) {
            int tmp;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)accessor.getLeftPos(), (float)accessor.getTopPos());
            int startX = CraftingTweaksDebugger.startDragSlot.field_7873;
            int startY = CraftingTweaksDebugger.startDragSlot.field_7872;
            int endX = CraftingTweaksDebugger.endDragSlot.field_7873;
            int endY = CraftingTweaksDebugger.endDragSlot.field_7872;
            if (startX > endX) {
                tmp = startX;
                startX = endX;
                endX = tmp;
            }
            if (startY > endY) {
                tmp = startY;
                startY = endY;
                endY = tmp;
            }
            for (int x = startX; x <= endX; ++x) {
                for (int y = startY; y <= endY; ++y) {
                    guiGraphics.method_25296(x, y, x + 16, y + 16, 419495680, 419495680);
                }
            }
            guiGraphics.method_51448().popMatrix();
        }
        if (currentMenuLabel != null) {
            guiGraphics.method_64038(class_310.method_1551().field_1772, (List)Lists.newArrayList((Object[])new class_2561[]{currentMenuLabel}), Optional.empty(), currentMenuLabelRect.method_3321() - 12, currentMenuLabelRect.method_3322() + 12);
        }
    }

    private static boolean onMouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
        if (!CraftingTweaks.debugMode) {
            return false;
        }
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            if (button == 0 && startDragSlot != null) {
                class_1703 menu = containerScreen.method_17577();
                String modId = CraftingTweaksDebugger.getModId(menu);
                endDragSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                if (endDragSlot != null) {
                    int gridSize = CraftingTweaksDebugger.endDragSlot.field_7874 - CraftingTweaksDebugger.startDragSlot.field_7874 + 1;
                    CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), CraftingTweaksDebugger.startDragSlot.field_7874, gridSize);
                }
                startDragSlot = null;
                return true;
            }
        }
        return false;
    }

    private static boolean onMouseClick(class_437 screen, class_11909 event) {
        if (!CraftingTweaks.debugMode) {
            return false;
        }
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            if (event.method_74245() == 0) {
                startDragSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                return startDragSlot != null;
            }
        }
        return false;
    }

    private static String getModId(class_1703 menu) {
        try {
            class_2960 key = class_7923.field_41187.method_10221((Object)menu.method_17358());
            return key != null ? key.method_12836() : "minecraft";
        }
        catch (UnsupportedOperationException e) {
            return "minecraft";
        }
    }

    private static void printJson(String modId, String containerClass, int gridSlotNumber, int gridSize) {
        CraftingTweaksRegistrationData data = new CraftingTweaksRegistrationData();
        data.setModId(modId);
        data.setContainerClass(containerClass);
        data.setGridSlotNumber(gridSlotNumber);
        data.setGridSize(gridSize);
        logger.info("\n\nExample for Crafting Tweaks datapack: datapacks/mypack/data/mypack/craftingtweaks_compat/{}.json\n\n{}\n\n", (Object)modId, (Object)gson.toJson((Object)data));
    }
}

