/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.Optional;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.command.CraftingTweaksCommand;
import net.blay09.mods.craftingtweaks.compat.VanillaCraftingGridProvider;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.crafting.ShapedRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.crafting.ShapelessRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.network.HelloMessage;
import net.blay09.mods.craftingtweaks.network.ModNetworking;
import net.blay09.mods.craftingtweaks.registry.ConfigJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.LegacyJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.ModFileJsonCompatLoader;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaks {
    public static final String MOD_ID = "craftingtweaks";
    public static boolean debugMode;
    public static final Logger logger;
    public static boolean isServerSideInstalled;

    public static void initialize(BalmRegistrars registrars) {
        CraftingTweaksConfig.initialize();
        ModNetworking.initialize(Balm.networking());
        Balm.commands().register(CraftingTweaksCommand::register);
        registrars.resourceReloadListeners(registrar -> registrar.register("json_registry", (PreparableReloadListener)new LegacyJsonCompatLoader()));
        CraftingTweaksAPI.registerCraftingGridProvider(new VanillaCraftingGridProvider());
        CraftingTweaksAPI.registerRecipeMapper(ShapedRecipe.class, new ShapedRecipeMatrixMapper());
        CraftingTweaksAPI.registerRecipeMapper(ShapelessRecipe.class, new ShapelessRecipeMatrixMapper());
        ServerPlayerCallback.Join.EVENT.register(player -> Balm.networking().sendTo((Player)player, (CustomPacketPayload)HelloMessage.INSTANCE));
        ItemCallback.Craft.After.EVENT.register((player, itemStack, craftMatrix) -> {
            Level level = player.level();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    RecipeManager recipeManager = serverLevel.getServer().getRecipeManager();
                    if (craftMatrix instanceof CraftingContainer) {
                        CraftingContainer craftingContainer = (CraftingContainer)craftMatrix;
                        Optional optionalRecipeHolder = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingContainer.asCraftInput(), level);
                        optionalRecipeHolder.ifPresent(recipeHolder -> CraftingTweaksAPI.setLastCraftedRecipe(serverPlayer, recipeHolder));
                    }
                }
            }
        });
        Balm.config().onConfigAvailable(CraftingTweaksConfig.class, config -> {
            ModFileJsonCompatLoader.load();
            ConfigJsonCompatLoader.load();
        });
    }

    static {
        logger = LoggerFactory.getLogger(CraftingTweaks.class);
        isServerSideInstalled = true;
    }
}

