/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;

public class ClientProvider {
    private final SimpleContainer lastCraftedMatrix = new SimpleContainer(9);
    private boolean hasLastCraftedMatrix;

    private MultiPlayerGameMode getController() {
        return Minecraft.getInstance().gameMode;
    }

    public void balanceGrid(Player entityPlayer, AbstractContainerMenu container, CraftingGrid grid) {
        ArrayListMultimap balanceSlots = ArrayListMultimap.create();
        int start = grid.getGridStartSlot(entityPlayer, container);
        int size = grid.getGridSize(entityPlayer, container);
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)container.slots.get(i);
            if (!slot.hasItem() || (itemStack = slot.getItem()).isEmpty()) continue;
            Identifier registryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            balanceSlots.put((Object)Objects.toString(registryName), (Object)slot);
        }
        for (String key : balanceSlots.keySet()) {
            ItemStack itemStack;
            Collection slotList = balanceSlots.get((Object)key);
            int average = 0;
            for (Slot slot : slotList) {
                itemStack = slot.getItem();
                if (itemStack.isEmpty()) continue;
                average += itemStack.getCount();
            }
            average = (int)Math.floor((float)average / (float)slotList.size());
            for (Slot slot : slotList) {
                if (!slot.hasItem() || (itemStack = slot.getItem()).isEmpty() || itemStack.getCount() <= average) continue;
                int mouseStackSize = itemStack.getCount();
                this.getController().handleInventoryMouseClick(container.containerId, slot.index, 0, ClickType.PICKUP, entityPlayer);
                for (Slot otherSlot : slotList) {
                    int otherStackSize;
                    ItemStack otherStack;
                    if (slot == otherSlot || !otherSlot.hasItem() || (otherStack = otherSlot.getItem()).isEmpty() || (otherStackSize = otherStack.getCount()) >= average) continue;
                    while (otherStackSize < average && mouseStackSize > average) {
                        this.getController().handleInventoryMouseClick(container.containerId, otherSlot.index, 1, ClickType.PICKUP, entityPlayer);
                        --mouseStackSize;
                        ++otherStackSize;
                    }
                }
                this.getController().handleInventoryMouseClick(container.containerId, slot.index, 0, ClickType.PICKUP, entityPlayer);
            }
        }
    }

    public void spreadGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid) {
        int tries = 0;
        while (tries < 9) {
            int i;
            ++tries;
            Slot biggestSlot = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (i = start; i < start + size; ++i) {
                Slot slot = (Slot)menu.slots.get(i);
                ItemStack itemStack = slot.getItem();
                if (itemStack.isEmpty() || itemStack.getCount() <= biggestSlotSize) continue;
                biggestSlot = slot;
                biggestSlotSize = itemStack.getCount();
            }
            if (biggestSlot == null) {
                return;
            }
            this.getController().handleInventoryMouseClick(menu.containerId, biggestSlot.index, 0, ClickType.PICKUP, player);
            for (i = start; i < start + size; ++i) {
                ItemStack itemStack;
                if (i == biggestSlot.index || !(itemStack = ((Slot)menu.slots.get(i)).getItem()).isEmpty() || biggestSlotSize <= 1) continue;
                this.getController().handleInventoryMouseClick(menu.containerId, i, 1, ClickType.PICKUP, player);
                if (--biggestSlotSize == 1) break;
            }
            this.getController().handleInventoryMouseClick(menu.containerId, biggestSlot.index, 0, ClickType.PICKUP, player);
        }
        this.balanceGrid(player, menu, grid);
    }

    public void clearGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean forced) {
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            this.getController().handleInventoryMouseClick(menu.containerId, i, 0, ClickType.QUICK_MOVE, player);
            menu.quickMoveStack(player, i);
            if (!forced || !((Slot)menu.slots.get(i)).hasItem()) continue;
            this.getController().handleInventoryMouseClick(menu.containerId, i, 0, ClickType.THROW, player);
        }
    }

    public void rotateGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean reverse) {
        if (grid.getGridSize(player, menu) != 9) {
            return;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return;
        }
        if (this.rotateGridWithBuffer(player, menu, grid, reverse)) {
            return;
        }
        int startSlot = grid.getGridStartSlot(player, menu);
        this.getController().handleInventoryMouseClick(menu.containerId, startSlot, 0, ClickType.PICKUP, player);
        int currentSlot = startSlot;
        do {
            currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, reverse);
            this.getController().handleInventoryMouseClick(menu.containerId, currentSlot, 0, ClickType.PICKUP, player);
        } while (currentSlot != startSlot);
    }

    private boolean rotateGridWithBuffer(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean counterClockwise) {
        int startSlot;
        int emptyBuffer = 0;
        int[] bufferSlot = new int[2];
        for (Slot slot : menu.slots) {
            if (!(slot.container instanceof Inventory) || slot.hasItem()) continue;
            bufferSlot[emptyBuffer] = slot.index;
            if (++emptyBuffer < 2) continue;
            break;
        }
        if (emptyBuffer < 2) {
            return false;
        }
        emptyBuffer = 0;
        int currentSlot = startSlot = grid.getGridStartSlot(player, menu);
        do {
            this.getController().handleInventoryMouseClick(menu.containerId, currentSlot, 0, ClickType.PICKUP, player);
            this.getController().handleInventoryMouseClick(menu.containerId, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
            emptyBuffer = (emptyBuffer + 1) % 2;
            this.getController().handleInventoryMouseClick(menu.containerId, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
            this.getController().handleInventoryMouseClick(menu.containerId, currentSlot, 0, ClickType.PICKUP, player);
        } while ((currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, counterClockwise)) != startSlot);
        emptyBuffer = (emptyBuffer + 1) % 2;
        this.getController().handleInventoryMouseClick(menu.containerId, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
        this.getController().handleInventoryMouseClick(menu.containerId, startSlot, 0, ClickType.PICKUP, player);
        return true;
    }

    public boolean transferIntoGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, Slot sourceSlot) {
        if (!(sourceSlot.hasItem() && sourceSlot.mayPickup(player) && grid.transferHandler().canTransferFrom(player, menu, sourceSlot, grid))) {
            return false;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return false;
        }
        this.getController().handleInventoryMouseClick(menu.containerId, sourceSlot.index, 0, ClickType.PICKUP, player);
        ItemStack mouseStack = menu.getCarried();
        if (mouseStack.isEmpty()) {
            return false;
        }
        boolean itemMoved = false;
        int firstEmptySlot = -1;
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            Slot craftSlot = (Slot)menu.slots.get(i);
            ItemStack craftStack = craftSlot.getItem();
            if (!craftStack.isEmpty()) {
                int spaceLeft;
                if (!ItemStack.isSameItemSameComponents((ItemStack)craftStack, (ItemStack)mouseStack) || (spaceLeft = Math.min(craftSlot.getMaxStackSize(), craftStack.getMaxStackSize()) - craftStack.getCount()) <= 0) continue;
                this.getController().handleInventoryMouseClick(menu.containerId, craftSlot.index, 0, ClickType.PICKUP, player);
                mouseStack = menu.getCarried();
                if (!mouseStack.isEmpty()) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot != -1) {
            this.getController().handleInventoryMouseClick(menu.containerId, firstEmptySlot, 0, ClickType.PICKUP, player);
            itemMoved = true;
        }
        if (!menu.getCarried().isEmpty()) {
            this.getController().handleInventoryMouseClick(menu.containerId, sourceSlot.index, 0, ClickType.PICKUP, player);
        }
        this.dropOffMouseStack(player, menu);
        return itemMoved;
    }

    private boolean dropOffMouseStack(Player player, AbstractContainerMenu menu) {
        return this.dropOffMouseStack(player, menu, -1);
    }

    private boolean dropOffMouseStack(Player player, AbstractContainerMenu menu, int ignoreSlot) {
        if (menu.getCarried().isEmpty()) {
            return true;
        }
        for (int i = 0; i < menu.slots.size(); ++i) {
            if (i == ignoreSlot) continue;
            Slot slot = (Slot)menu.slots.get(i);
            if (slot.container != player.getInventory()) continue;
            ItemStack mouseItem = menu.getCarried();
            ItemStack slotStack = slot.getItem();
            if (slotStack.isEmpty()) {
                this.getController().handleInventoryMouseClick(menu.containerId, i, 0, ClickType.PICKUP, player);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)mouseItem)) {
                this.getController().handleInventoryMouseClick(menu.containerId, i, 0, ClickType.PICKUP, player);
            }
            if (!menu.getCarried().isEmpty()) continue;
            return true;
        }
        return menu.getCarried().isEmpty();
    }

    private void decompress(Player player, AbstractContainerMenu menu, CraftingGrid grid, Slot mouseSlot, CompressType compressType) {
        if (!mouseSlot.hasItem()) {
            return;
        }
        boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
        this.clearGrid(player, menu, grid, false);
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)menu.slots.get(i)).hasItem()) continue;
            return;
        }
        for (Slot slot : menu.slots) {
            if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.container instanceof Inventory) || !slot.hasItem() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)mouseSlot.getItem())) continue;
            this.getController().handleInventoryMouseClick(menu.containerId, mouseSlot.index, 0, ClickType.PICKUP, player);
            this.getController().handleInventoryMouseClick(menu.containerId, start, 0, ClickType.PICKUP, player);
            for (Slot resultSlot : menu.slots) {
                if (!(resultSlot instanceof ResultSlot) || !resultSlot.hasItem()) continue;
                this.getController().handleInventoryMouseClick(menu.containerId, resultSlot.index, 0, decompressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, player);
                break;
            }
            this.dropOffMouseStack(player, menu, mouseSlot.index);
            this.getController().handleInventoryMouseClick(menu.containerId, start, 0, ClickType.PICKUP, player);
            this.getController().handleInventoryMouseClick(menu.containerId, mouseSlot.index, 0, ClickType.PICKUP, player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(LocalPlayer player, AbstractContainerMenu menu, CraftingGrid grid, Slot mouseSlot, CompressType compressType) {
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_ONE || compressType == CompressType.DECOMPRESS_STACK) {
            this.decompress((Player)player, menu, grid, mouseSlot, compressType);
            return;
        }
        if (!mouseSlot.hasItem()) {
            return;
        }
        boolean compressAll = compressType != CompressType.COMPRESS_ONE;
        this.clearGrid((Player)player, menu, grid, false);
        int start = grid.getGridStartSlot((Player)player, menu);
        int size = grid.getGridSize((Player)player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)menu.slots.get(i)).hasItem()) continue;
            return;
        }
        for (Slot slot : menu.slots) {
            if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot || !(slot.container instanceof Inventory) || !slot.hasItem() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)mouseSlot.getItem())) continue;
            ItemStack mouseStack = slot.getItem();
            if (size == 9 && !mouseStack.isEmpty() && mouseStack.getCount() >= 9) {
                InventoryCraftingCompress craftingContainer3x3 = new InventoryCraftingCompress(menu, 3, mouseStack);
                result = ClientProvider.findMatchingResult(craftingContainer3x3.asCraftInput(), player);
                if (!result.isEmpty() && !this.isCompressBlacklisted(result)) {
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                    for (int i = start; i < start + size; ++i) {
                        this.getController().handleInventoryMouseClick(menu.containerId, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    }
                    this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                } else {
                    InventoryCraftingCompress craftingContainer2x2 = new InventoryCraftingCompress(menu, 2, mouseStack);
                    result = ClientProvider.findMatchingResult(craftingContainer2x2.asCraftInput(), player);
                    if (result.isEmpty() || this.isCompressBlacklisted(result)) return;
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                }
            } else if (size >= 4 && !mouseStack.isEmpty() && mouseStack.getCount() >= 4) {
                InventoryCraftingCompress craftingContainer = new InventoryCraftingCompress(menu, 2, mouseStack);
                result = ClientProvider.findMatchingResult(craftingContainer.asCraftInput(), player);
                if (result.isEmpty() || this.isCompressBlacklisted(result)) return;
                this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                if (size == 4) {
                    for (int i = start; i < start + size; ++i) {
                        this.getController().handleInventoryMouseClick(menu.containerId, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    }
                } else {
                    this.getController().handleInventoryMouseClick(menu.containerId, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().handleInventoryMouseClick(menu.containerId, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                }
                this.getController().handleInventoryMouseClick(menu.containerId, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
            }
            for (Slot resultSlot : menu.slots) {
                if (!(resultSlot instanceof ResultSlot) || !resultSlot.hasItem()) continue;
                this.getController().handleInventoryMouseClick(menu.containerId, resultSlot.index, 0, compressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, (Player)player);
                break;
            }
            this.dropOffMouseStack((Player)player, menu, slot.index);
            for (int i = start; i < start + size; ++i) {
                if (!((Slot)menu.slots.get(i)).hasItem()) continue;
                this.getController().handleInventoryMouseClick(menu.containerId, i, 0, ClickType.PICKUP, (Player)player);
                this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
            }
            this.dropOffMouseStack((Player)player, menu);
        }
    }

    private static <T extends RecipeInput> ItemStack findMatchingResult(T craftingInventory, LocalPlayer player) {
        for (RecipeCollection recipeList : player.getRecipeBook().getCollections()) {
            for (RecipeDisplayEntry recipeDisplayEntry : recipeList.getRecipes()) {
            }
        }
        return ItemStack.EMPTY;
    }

    private static int getDragSplittingButton(int id, int limit) {
        return id & 3 | (limit & 3) << 2;
    }

    private boolean isCompressBlacklisted(ItemStack result) {
        Identifier registryName = BuiltInRegistries.ITEM.getKey((Object)result.getItem());
        return registryName != null && CraftingTweaksConfig.getActive().common.compressDenylist.contains(registryName.toString());
    }

    public void onItemCrafted(Container craftMatrix) {
        if (craftMatrix.getContainerSize() <= 9) {
            for (int i = 0; i < this.lastCraftedMatrix.getContainerSize(); ++i) {
                if (i < craftMatrix.getContainerSize()) {
                    this.lastCraftedMatrix.setItem(i, craftMatrix.getItem(i).copy());
                    continue;
                }
                this.lastCraftedMatrix.setItem(i, ItemStack.EMPTY);
            }
            this.hasLastCraftedMatrix = true;
        }
    }

    public void refillLastCrafted(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean fullStack) {
        ItemStack itemStack;
        int i;
        if (!this.hasLastCraftedMatrix) {
            return;
        }
        this.dropOffMouseStack(player, menu);
        int gridStart = grid.getGridStartSlot(player, menu);
        int gridSize = grid.getGridSize(player, menu);
        if (menu.slots.size() < gridStart + gridSize || gridSize != this.lastCraftedMatrix.getContainerSize()) {
            return;
        }
        block0: for (i = 0; i < this.lastCraftedMatrix.getContainerSize(); ++i) {
            itemStack = this.lastCraftedMatrix.getItem(i);
            if (!itemStack.isEmpty()) {
                for (Slot slot : menu.slots) {
                    if (!(slot.container instanceof Inventory) || !slot.hasItem() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)itemStack)) continue;
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, player);
                    this.getController().handleInventoryMouseClick(menu.containerId, gridStart + i, fullStack ? 0 : 1, ClickType.PICKUP, player);
                    this.getController().handleInventoryMouseClick(menu.containerId, slot.index, 0, ClickType.PICKUP, player);
                    continue block0;
                }
                continue;
            }
            if (!((Slot)menu.slots.get(gridStart + i)).hasItem()) continue;
            this.getController().handleInventoryMouseClick(menu.containerId, gridStart + i, 0, ClickType.PICKUP, player);
            if (this.dropOffMouseStack(player, menu)) continue;
            this.getController().handleInventoryMouseClick(menu.containerId, gridStart + i, 0, ClickType.PICKUP, player);
            return;
        }
        if (fullStack) {
            block2: for (i = 0; i < this.lastCraftedMatrix.getContainerSize(); ++i) {
                itemStack = this.lastCraftedMatrix.getItem(i);
                if (itemStack.isEmpty() || ((Slot)menu.slots.get(gridStart + i)).hasItem()) continue;
                for (int j = gridStart; j < gridStart + gridSize; ++j) {
                    ItemStack gridStack;
                    if (j == gridStart + i || (gridStack = ((Slot)menu.slots.get(j)).getItem()).getCount() <= 1 || !ItemStack.isSameItemSameComponents((ItemStack)gridStack, (ItemStack)itemStack)) continue;
                    this.getController().handleInventoryMouseClick(menu.containerId, j, 0, ClickType.PICKUP, player);
                    this.getController().handleInventoryMouseClick(menu.containerId, gridStart + i, 1, ClickType.PICKUP, player);
                    this.getController().handleInventoryMouseClick(menu.containerId, j, 0, ClickType.PICKUP, player);
                    continue block2;
                }
            }
            this.balanceGrid(player, menu, grid);
        }
        this.dropOffMouseStack(player, menu);
    }

    public boolean rotateIgnoresSlotId(int slotId) {
        return slotId == 4;
    }

    public int rotateSlotId(int slotId, boolean counterClockwise) {
        if (!counterClockwise) {
            switch (slotId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 5: {
                    return 8;
                }
                case 8: {
                    return 7;
                }
                case 7: {
                    return 6;
                }
                case 6: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }
}

