/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.gui.screens.BalmScreenUtils;
import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.InternalClientMethodsImpl;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksDebugger;
import net.blay09.mods.craftingtweaks.client.ModKeyMappings;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.network.CraftStackMessage;
import net.blay09.mods.craftingtweaks.network.TransferStackMessage;
import net.blay09.mods.kuma.api.Kuma;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class CraftingTweaksClient {
    private static final ClientProvider clientProvider = new ClientProvider();
    private static boolean ignoreMouseUp;
    private static int rightClickCraftingSlot;
    private static AbstractWidget unpleasantButton;
    private static int fixedUnpleasantButtonX;

    public static void initialize(BalmClientRegistrars registrars) {
        CraftingTweaksClientAPI.setupAPI(new InternalClientMethodsImpl());
        CraftingTweaksClientAPI.registerCraftingGridGuiHandler(AbstractContainerScreen.class, new DefaultGridGuiHandler());
        ModKeyMappings.initialize();
        ItemCallback.Craft.After.EVENT.register(CraftingTweaksClient::onItemCrafted);
        ClientLifecycleCallback.ConnectedToServer.EVENT.register(client -> {
            CraftingTweaks.isServerSideInstalled = false;
        });
        ScreenCallback.Init.After.EVENT.register(CraftingTweaksClient::screenInitialized);
        ScreenCallback.KeyPress.After.EVENT.register(CraftingTweaksClient::screenKeyPressed);
        ScreenCallback.MousePress.Before.EVENT.register(CraftingTweaksClient::screenMouseClick);
        ScreenCallback.MouseRelease.Before.EVENT.register(CraftingTweaksClient::screenMouseRelease);
        ScreenCallback.Render.BEFORE.register(CraftingTweaksClient::screenAboutToDraw);
        ScreenCallback.Render.AFTER.register(CraftingTweaksClient::screenDrawn);
        CraftingTweaksDebugger.initialize();
    }

    public static boolean screenKeyPressed(Screen screen, KeyEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Window window = Minecraft.getInstance().getWindow();
            if (CraftingTweaks.isServerSideInstalled && GLFW.glfwGetKey((long)window.handle(), (int)66) == 1 && GLFW.glfwGetKey((long)window.handle(), (int)76) == 1 && GLFW.glfwGetKey((long)window.handle(), (int)65) == 1 && (GLFW.glfwGetKey((long)window.handle(), (int)89) == 1 || GLFW.glfwGetKey((long)window.handle(), (int)90) == 1)) {
                CraftingTweaks.isServerSideInstalled = false;
                player.displayClientMessage((Component)Component.literal((String)"[CraftingTweaks] Enabled client-side testing mode"), false);
                return true;
            }
        }
        return false;
    }

    public static boolean screenMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    public static boolean screenMouseClick(Screen screen, MouseButtonEvent event) {
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null) {
            return false;
        }
        Slot mouseSlot = screen instanceof AbstractContainerScreen ? ((AbstractContainerScreenAccessor)screen).getHoveredSlot() : null;
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (grid != null) {
            if (ModKeyMappings.keyTransferStack.isActiveAndDown()) {
                if (mouseSlot != null && mouseSlot.hasItem()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (Kuma.hasShiftDown()) {
                        ItemStack mouseSlotStack = mouseSlot.getItem();
                        for (Slot slot : menu.slots) {
                            ItemStack slotStack;
                            if (!slot.hasItem() || mouseSlot == slot || !ItemStack.isSameItemSameComponents((ItemStack)(slotStack = slot.getItem()), (ItemStack)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (Slot slot : transferSlots) {
                            Balm.networking().sendToServer((CustomPacketPayload)new TransferStackMessage(grid.getId(), slot.index));
                        }
                    } else {
                        for (Slot slot : transferSlots) {
                            clientProvider.transferIntoGrid((Player)player, menu, grid, slot);
                        }
                        ignoreMouseUp = true;
                    }
                    return true;
                }
            } else if (CraftingTweaksConfig.getActive().client.rightClickCraftsStack && event.isRight() && mouseSlot instanceof ResultSlot) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.networking().sendToServer((CustomPacketPayload)new CraftStackMessage(mouseSlot.index));
                } else {
                    rightClickCraftingSlot = mouseSlot.index;
                }
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    public static void screenInitialized(Screen screen) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            GridGuiHandler guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen);
            unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler);
            if (unpleasantButton != null) {
                fixedUnpleasantButtonX = unpleasantButton.getX();
            }
            List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(containerScreen.getMenu());
            for (CraftingGrid grid : grids) {
                String modId = grid.getId().getNamespace();
                CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
                if (config != CraftingTweaksMode.DEFAULT && config != CraftingTweaksMode.BUTTONS) continue;
                guiHandler.createButtons(containerScreen, grid, widget -> BalmScreenUtils.addRenderableWidget((Screen)screen, (GuiEventListener)widget));
            }
        }
    }

    private static void handleRightClickCrafting() {
        if (rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = rightClickCraftingSlot;
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        MultiPlayerGameMode playerController = Minecraft.getInstance().gameMode;
        if (playerController == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null) {
            return;
        }
        if (craftingSlot >= menu.slots.size()) {
            return;
        }
        Slot mouseSlot = (Slot)menu.slots.get(craftingSlot);
        if (!mouseSlot.hasItem()) {
            rightClickCraftingSlot = mouseSlot.index;
            return;
        }
        ItemStack mouseStack = menu.getCarried();
        if (mouseStack.isEmpty() || mouseStack.getCount() + mouseSlot.getItem().getCount() <= mouseStack.getMaxStackSize()) {
            playerController.handleInventoryMouseClick(menu.containerId, mouseSlot.index, 0, ClickType.PICKUP, (Player)player);
            rightClickCraftingSlot = mouseSlot.index;
        }
    }

    public static void screenAboutToDraw(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (screen instanceof AbstractContainerScreen) {
            GridGuiHandler guiHandler;
            int unpleasantX;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (unpleasantButton != null && (unpleasantX = unpleasantButton.getX()) != fixedUnpleasantButtonX && (unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen))) != null) {
                fixedUnpleasantButtonX = unpleasantButton.getX();
            }
        }
    }

    public static void screenDrawn(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        CraftingTweaksClient.handleRightClickCrafting();
    }

    private static void onItemCrafted(Player player, ItemStack itemStack, Container craftMatrix) {
        clientProvider.onItemCrafted(craftMatrix);
    }

    public static ClientProvider getClientProvider() {
        return clientProvider;
    }

    static {
        rightClickCraftingSlot = -1;
    }
}

