/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaksDebugger {
    private static final Logger logger = LoggerFactory.getLogger(CraftingTweaksDebugger.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Rect2i currentMenuLabelRect = new Rect2i(0, 0, 0, 0);
    private static Component currentMenuLabel;
    private static Slot startDragSlot;
    private static Slot endDragSlot;

    public static void initialize() {
        ScreenCallback.Init.After.EVENT.register(screen -> {
            if (!CraftingTweaks.debugMode) {
                return;
            }
            if (CraftingTweaks.debugMode && screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                AbstractContainerMenu menu = containerScreen.getMenu();
                String modId = CraftingTweaksDebugger.getModId(menu);
                CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), 1, 9);
                currentMenuLabel = Component.literal((String)menu.getClass().getName());
                int labelWidth = Minecraft.getInstance().font.width((FormattedText)currentMenuLabel);
                currentMenuLabelRect.setX(((AbstractContainerScreenAccessor)screen).getLeftPos() + ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2 - labelWidth / 2);
                currentMenuLabelRect.setY(((AbstractContainerScreenAccessor)screen).getTopPos() - 20);
                currentMenuLabelRect.setWidth(labelWidth);
                currentMenuLabelRect.setHeight(16);
            }
        });
        ScreenCallback.MouseRelease.Before.EVENT.register(CraftingTweaksDebugger::onMouseRelease);
        ScreenCallback.MousePress.Before.EVENT.register(CraftingTweaksDebugger::onMouseClick);
        ScreenCallback.Render.AFTER_BACKGROUND.register(CraftingTweaksDebugger::onScreenDrawn);
    }

    public static void onScreenDrawn(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        AbstractContainerScreenAccessor accessor;
        if (!CraftingTweaks.debugMode) {
            return;
        }
        if (startDragSlot != null && screen instanceof AbstractContainerScreenAccessor && (endDragSlot = (accessor = (AbstractContainerScreenAccessor)screen).getHoveredSlot()) != null) {
            int tmp;
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)accessor.getLeftPos(), (float)accessor.getTopPos());
            int startX = CraftingTweaksDebugger.startDragSlot.x;
            int startY = CraftingTweaksDebugger.startDragSlot.y;
            int endX = CraftingTweaksDebugger.endDragSlot.x;
            int endY = CraftingTweaksDebugger.endDragSlot.y;
            if (startX > endX) {
                tmp = startX;
                startX = endX;
                endX = tmp;
            }
            if (startY > endY) {
                tmp = startY;
                startY = endY;
                endY = tmp;
            }
            for (int x = startX; x <= endX; ++x) {
                for (int y = startY; y <= endY; ++y) {
                    guiGraphics.fillGradient(x, y, x + 16, y + 16, 419495680, 419495680);
                }
            }
            guiGraphics.pose().popMatrix();
        }
        if (currentMenuLabel != null) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (List)Lists.newArrayList((Object[])new Component[]{currentMenuLabel}), Optional.empty(), currentMenuLabelRect.getX() - 12, currentMenuLabelRect.getY() + 12);
        }
    }

    private static boolean onMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (!CraftingTweaks.debugMode) {
            return false;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (button == 0 && startDragSlot != null) {
                AbstractContainerMenu menu = containerScreen.getMenu();
                String modId = CraftingTweaksDebugger.getModId(menu);
                endDragSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                if (endDragSlot != null) {
                    int gridSize = CraftingTweaksDebugger.endDragSlot.index - CraftingTweaksDebugger.startDragSlot.index + 1;
                    CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), CraftingTweaksDebugger.startDragSlot.index, gridSize);
                }
                startDragSlot = null;
                return true;
            }
        }
        return false;
    }

    private static boolean onMouseClick(Screen screen, MouseButtonEvent event) {
        if (!CraftingTweaks.debugMode) {
            return false;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (event.button() == 0) {
                startDragSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                return startDragSlot != null;
            }
        }
        return false;
    }

    private static String getModId(AbstractContainerMenu menu) {
        try {
            Identifier key = BuiltInRegistries.MENU.getKey((Object)menu.getType());
            return key != null ? key.getNamespace() : "minecraft";
        }
        catch (UnsupportedOperationException e) {
            return "minecraft";
        }
    }

    private static void printJson(String modId, String containerClass, int gridSlotNumber, int gridSize) {
        CraftingTweaksRegistrationData data = new CraftingTweaksRegistrationData();
        data.setModId(modId);
        data.setContainerClass(containerClass);
        data.setGridSlotNumber(gridSlotNumber);
        data.setGridSize(gridSize);
        logger.info("\n\nExample for Crafting Tweaks datapack: datapacks/mypack/data/mypack/craftingtweaks_compat/{}.json\n\n{}\n\n", (Object)modId, (Object)gson.toJson((Object)data));
    }
}

