/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record BalanceMessage(Identifier id, boolean spread) implements CustomPacketPayload
{
    public static CustomPacketPayload.Type<BalanceMessage> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"craftingtweaks", (String)"balance"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BalanceMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)Identifier.STREAM_CODEC, BalanceMessage::id, (StreamCodec)ByteBufCodecs.BOOL, BalanceMessage::spread, BalanceMessage::new);

    public static void handle(ServerPlayer player, BalanceMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu != null) {
            CraftingTweaksProviderManager.getCraftingGrid(menu, message.id).ifPresent(grid -> {
                if (message.spread) {
                    grid.balanceHandler().spreadGrid((CraftingGrid)grid, (Player)player, menu);
                } else {
                    grid.balanceHandler().balanceGrid((CraftingGrid)grid, (Player)player, menu);
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

