/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigJsonCompatLoader.class);
    private static final Gson gson = new Gson();
    private static final List<CraftingGridProvider> providersFromConfig = new ArrayList<CraftingGridProvider>();

    public static void load() {
        for (CraftingGridProvider providersFromDataPack : providersFromConfig) {
            CraftingTweaksAPI.unregisterCraftingGridProvider(providersFromDataPack);
        }
        providersFromConfig.clear();
        File configDir = new File(Balm.config().getConfigDir(), "craftingtweaks/grids");
        if (!configDir.exists() && !configDir.mkdirs()) {
            logger.error("Failed to create CraftingTweaks config directory {}", (Object)configDir);
            return;
        }
        File[] files = configDir.listFiles(it -> it.getName().endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                CraftingGridProvider gridProvider = ConfigJsonCompatLoader.load(file, (CraftingTweaksRegistrationData)gson.fromJson((Reader)reader, CraftingTweaksRegistrationData.class));
                if (gridProvider == null) continue;
                providersFromConfig.add(gridProvider);
            }
            catch (IOException e) {
                logger.error("Failed to load CraftingTweaks file {}", (Object)file, (Object)e);
            }
        }
    }

    private static boolean isCompatEnabled(String modId) {
        return !CraftingTweaksConfig.getActive().client.disabledAddons.contains(modId);
    }

    private static CraftingGridProvider load(File resource, CraftingTweaksRegistrationData data) {
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.platform().isModLoaded(modId) || !ConfigJsonCompatLoader.isCompatEnabled(modId) || !data.isEnabled()) {
            return null;
        }
        CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
        if (gridProvider != null) {
            CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
            logger.info("Config file {} has registered {} of {} with CraftingTweaks", new Object[]{resource, data.getContainerClass(), modId});
        }
        return gridProvider;
    }
}

