/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModFileJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ModFileJsonCompatLoader.class);
    private static final Gson gson = new Gson();
    private static final List<CraftingGridProvider> providersFromModFiles = new ArrayList<CraftingGridProvider>();

    public static void load() {
        for (CraftingGridProvider providersFromDataPack : providersFromModFiles) {
            CraftingTweaksAPI.unregisterCraftingGridProvider(providersFromDataPack);
        }
        providersFromModFiles.clear();
        Balm.platform().loadedPrimaryModIds().forEach(modId -> Balm.platform().visitModResources(modId, "craftingtweaks/grids", resource -> {
            if (resource.extension().equals("json")) {
                try (BufferedReader reader = resource.bufferedReader();){
                    CraftingGridProvider gridProvider = ModFileJsonCompatLoader.load(modId, (CraftingTweaksRegistrationData)gson.fromJson((Reader)reader, CraftingTweaksRegistrationData.class));
                    if (gridProvider != null) {
                        providersFromModFiles.add(gridProvider);
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to load CraftingTweaks file {}", (Object)resource.name(), (Object)e);
                }
            }
        }));
    }

    private static boolean isCompatEnabled(String modId) {
        return !CraftingTweaksConfig.getActive().client.disabledAddons.contains(modId);
    }

    private static CraftingGridProvider load(String resourceId, CraftingTweaksRegistrationData data) {
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.platform().isModLoaded(modId) || !ModFileJsonCompatLoader.isCompatEnabled(modId) || !data.isEnabled()) {
            return null;
        }
        CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
        if (gridProvider != null) {
            CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
            logger.info("Mod file {} has registered {} of {} with CraftingTweaks", new Object[]{resourceId, data.getContainerClass(), modId});
        }
        return gridProvider;
    }
}

