/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chameleon.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import moe.caramel.chameleon.Main;
import moe.caramel.chameleon.util.MacosUtil;
import moe.caramel.chameleon.util.ResourceIo;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3808;
import net.minecraft.class_5455;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class ModConfig
extends class_3808<ModConfig> {
    private static final Path MOD_CONFIG = new File("./config/caramel.chameleon.properties").toPath();
    private static final int CURRENT_CONFIG_VERSION = 1;
    public static final class_2960 ORIGINAL_MAC_ICON = class_2960.method_60656((String)"icons/minecraft.icns");
    public static final class_2960 ORIGINAL_WIN_ICON = class_2960.method_60656((String)"icons/icon_128x128.png");
    public static final Map<class_2960, String[]> VANILLA_ICON_SET = Map.ofEntries(Map.entry(ORIGINAL_MAC_ICON, new String[]{"icons", "minecraft.icns"}), Map.entry(class_2960.method_60656((String)"icons/icon_16x16.png"), new String[]{"icons", "icon_16x16.png"}), Map.entry(class_2960.method_60656((String)"icons/icon_32x32.png"), new String[]{"icons", "icon_32x32.png"}), Map.entry(class_2960.method_60656((String)"icons/icon_48x48.png"), new String[]{"icons", "icon_48x48.png"}), Map.entry(ORIGINAL_WIN_ICON, new String[]{"icons", "icon_128x128.png"}), Map.entry(class_2960.method_60656((String)"icons/icon_256x256.png"), new String[]{"icons", "icon_256x256.png"}), Map.entry(class_2960.method_60656((String)"snapshot/icons/icon_16x16.png"), new String[]{"icons", "snapshot", "icon_16x16.png"}), Map.entry(class_2960.method_60656((String)"snapshot/icons/icon_32x32.png"), new String[]{"icons", "snapshot", "icon_32x32.png"}), Map.entry(class_2960.method_60656((String)"snapshot/icons/icon_48x48.png"), new String[]{"icons", "snapshot", "icon_48x48.png"}), Map.entry(class_2960.method_60656((String)"snapshot/icons/icon_128x128.png"), new String[]{"icons", "snapshot", "icon_128x128.png"}), Map.entry(class_2960.method_60656((String)"snapshot/icons/icon_256x256.png"), new String[]{"icons", "snapshot", "icon_256x256.png"}));
    public static final Function<class_310, Set<class_2960>> GET_ICON_SET = client -> {
        ObjectOpenHashSet iconSet = new ObjectOpenHashSet();
        client.method_1478().method_14488("icons", arg_0 -> ModConfig.lambda$static$0((Set)iconSet, arg_0));
        iconSet.addAll(VANILLA_ICON_SET.keySet());
        return iconSet;
    };
    private static ModConfig instance;
    public final class_3808.class_3809<Integer> configVersion = this.method_16730("config-version", s -> s == null ? 0 : Integer.parseInt(s), 1);
    public final class_3808.class_3809<class_2960> iconLocation = this.method_16730("icon-location", class_2960::method_12829, Main.ON_OSX ? ORIGINAL_MAC_ICON : ORIGINAL_WIN_ICON);

    public static ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    private ModConfig() {
        this(class_3808.method_16727((Path)MOD_CONFIG));
    }

    private ModConfig(Properties properties) {
        super(properties);
    }

    @NotNull
    protected ModConfig reload(class_5455 registryAccess, Properties properties) {
        instance = new ModConfig(properties);
        instance.method_16728(MOD_CONFIG);
        return ModConfig.getInstance();
    }

    public static void changeIcon(class_310 client, class_2960 icon) throws IOException {
        String[] vanillaPath = VANILLA_ICON_SET.get(icon);
        class_7367<InputStream> iconSupplier = vanillaPath != null ? Objects.requireNonNull(client.method_45573().method_14410(vanillaPath)) : ResourceIo.create((class_3298)client.method_1478().method_14486(icon).get());
        if (Main.ON_OSX) {
            MacosUtil.method_41718(iconSupplier);
        } else {
            ModConfig.setWindowsIcon(client, iconSupplier);
        }
        ModConfig.getInstance().iconLocation.method_16745(null, (Object)icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setWindowsIcon(class_310 client, class_7367<InputStream> icon) throws IOException {
        ByteBuffer value = null;
        try {
            try (MemoryStack stack = MemoryStack.stackPush();
                 class_1011 image = class_1011.method_4309((InputStream)((InputStream)icon.get()));){
                GLFWImage.Buffer images = GLFWImage.malloc((int)1, (MemoryStack)stack);
                value = MemoryUtil.memAlloc((int)(image.method_4307() * image.method_4323() * 4));
                value.asIntBuffer().put(image.method_48463());
                images.position(0);
                images.width(image.method_4307());
                images.height(image.method_4323());
                images.pixels(value);
                GLFW.glfwSetWindowIcon((long)client.method_22683().method_4490(), (GLFWImage.Buffer)((GLFWImage.Buffer)images.position(0)));
            }
            if (value == null) return;
        }
        catch (Throwable throwable) {
            if (value == null) throw throwable;
            MemoryUtil.memFree(value);
            throw throwable;
        }
        MemoryUtil.memFree((Buffer)value);
    }

    private static /* synthetic */ boolean lambda$static$0(Set iconSet, class_2960 resource) {
        if (resource != null) {
            iconSet.add(resource);
            return true;
        }
        return false;
    }
}

