/*
 * Decompiled with CFR 0.152.
 */
package com.fractial.shulk.mixin;

import com.fractial.shulk.world.inventory.IShulkerBoxMenu;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public abstract class BlockItemMixin {
    @Shadow
    public abstract Block getBlock();

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (!(this.getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        if (context.getItemInHand().getCount() != 1) {
            return;
        }
        if (Objects.requireNonNull(context.getPlayer()).isShiftKeyDown()) {
            return;
        }
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IShulkerBoxMenu.open(serverPlayer, context.getItemInHand());
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }
}

