/*
 * Decompiled with CFR 0.152.
 */
package com.fractial.shulk.mixin;

import com.fractial.shulk.world.inventory.IShulkerBoxMenu;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void use(Level level, Player player, InteractionHand usedHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemMixin itemMixin = this;
        if (!(itemMixin instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)itemMixin;
        if (!(blockItem.getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemStack usedItemStack = player.getItemInHand(usedHand);
        if (usedItemStack.getCount() != 1) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IShulkerBoxMenu.open(serverPlayer, usedItemStack);
        }
        cir.setReturnValue((Object)InteractionResultHolder.success((Object)usedItemStack));
    }
}

