/*
 * Decompiled with CFR 0.152.
 */
package com.fractial.shulk.world;

import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IShulkerBoxContainer
implements Container {
    protected ItemStack shulkerBoxItemStack;
    protected int containerSize;
    protected NonNullList<ItemStack> itemStacks;

    public IShulkerBoxContainer(@Nullable ServerPlayer serverPlayer, ItemStack shulkerBoxItemStack, int containerSize) {
        SeededContainerLoot loot;
        this.shulkerBoxItemStack = shulkerBoxItemStack;
        this.containerSize = containerSize;
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ItemContainerContents contents = (ItemContainerContents)shulkerBoxItemStack.get(DataComponents.CONTAINER);
        if (contents != null) {
            contents.copyInto(this.itemStacks);
        }
        if ((loot = (SeededContainerLoot)shulkerBoxItemStack.get(DataComponents.CONTAINER_LOOT)) != null) {
            this.fillWithLoot(serverPlayer, loot);
            shulkerBoxItemStack.remove(DataComponents.CONTAINER_LOOT);
        }
    }

    public void fillWithLoot(@Nullable ServerPlayer serverPlayer, SeededContainerLoot loot) {
        if (serverPlayer == null) {
            return;
        }
        LootTable lootTable = Objects.requireNonNull(serverPlayer.getServer()).reloadableRegistries().getLootTable(loot.lootTable());
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)serverPlayer.level());
        builder.withLuck(serverPlayer.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer);
        lootTable.fill((Container)this, builder.create(LootContextParamSets.CHEST), loot.seed());
        this.setChanged();
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    public boolean isEmpty() {
        return this.itemStacks.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.itemStacks, (int)index, (int)amount);
        this.setChanged();
        return stack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = ContainerHelper.takeItem(this.itemStacks, (int)index);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
    }

    public int getMaxStackSize() {
        return this.itemStacks.size();
    }

    public void setChanged() {
        this.shulkerBoxItemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.itemStacks));
    }

    public boolean stillValid(Player player) {
        return player.getInventory().contains(this.shulkerBoxItemStack);
    }

    public void clearContent() {
        this.itemStacks.clear();
        this.setChanged();
    }

    public void startOpen(@NotNull Player player) {
        player.level().playSound(null, player.getOnPos(), SoundEvents.SHULKER_BOX_OPEN, SoundSource.PLAYERS, 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
    }

    public void stopOpen(@NotNull Player player) {
        this.setChanged();
        player.level().playSound(null, player.getOnPos(), SoundEvents.SHULKER_BOX_CLOSE, SoundSource.PLAYERS, 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
    }
}

