/*
 * Decompiled with CFR 0.152.
 */
package com.fractial.shulk.world.inventory;

import com.fractial.shulk.world.IShulkerBoxContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IShulkerBoxMenu
extends ShulkerBoxMenu {
    protected ServerPlayer serverPlayer;
    protected ItemStack shulkerBoxItemStack;

    public IShulkerBoxMenu(int containerId, Inventory playerInventory, ServerPlayer serverPlayer, ItemStack shulkerBoxItemStack) {
        super(containerId, playerInventory, (Container)new IShulkerBoxContainer(serverPlayer, shulkerBoxItemStack, 27));
        this.serverPlayer = serverPlayer;
        this.shulkerBoxItemStack = shulkerBoxItemStack;
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            super.clicked(slotId, button, clickType, player);
            return;
        }
        ItemStack stack = ((Slot)this.slots.get(slotId)).getItem();
        if (stack == this.shulkerBoxItemStack) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public static void open(ServerPlayer serverPlayer, final ItemStack shulkerBoxItemStack) {
        serverPlayer.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return shulkerBoxItemStack.getHoverName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
                if (!(player instanceof ServerPlayer)) {
                    return null;
                }
                ServerPlayer serverPlayer1 = (ServerPlayer)player;
                return new IShulkerBoxMenu(i, inventory, serverPlayer1, shulkerBoxItemStack);
            }
        });
    }
}

