/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret;

import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.jtorleonstudios.libraryferret.items.Items;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="libraryferret")
public class LibraryFerret {
    public static boolean isLOADED = false;
    public static final String MOD_ID = "libraryferret";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Optional<RegistryObject<CreativeModeTab>> FERRET_ITEM_GROUP = Optional.empty();
    public static final Props ENABLED_FERRET_ITEM_GROUP = Props.create("creative", "enable_item_group_ferret", false);
    public static final Configuration CONF = new Configuration("libraryferret", ENABLED_FERRET_ITEM_GROUP);

    public LibraryFerret(FMLJavaModLoadingContext context) {
        isLOADED = false;
        LOGGER.info("Initialize mod Library Ferret");
        BusGroup e = context.getModBusGroup();
        Items.registerItems(e);
        if (CONF.getBoolOrDefault(ENABLED_FERRET_ITEM_GROUP)) {
            this.registerCreativeTab(e);
        }
        FMLCommonSetupEvent.getBus((BusGroup)e).addListener(this::doCommonStuff);
        isLOADED = true;
        LOGGER.info("Initialized mod Library Ferret");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void registerCreativeTab(BusGroup e) {
        DeferredRegister TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MOD_ID);
        CreativeModeTab tab = CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)Blocks.CHEST)).title((Component)Component.translatable((String)"itemGroup.libraryferret.libraryferret")).displayItems((features, output) -> output.acceptAll(Stream.of((Item)Items.IRON_COIN.get(), (Item)Items.GOLD_COIN.get(), (Item)Items.EMERALD_COIN.get(), (Item)Items.DIAMOND_COIN.get(), (Item)Items.NETHERITE_COIN.get()).map(Item::getDefaultInstance).toList())).build();
        FERRET_ITEM_GROUP = Optional.of(TAB.register("libraryferret.libraryferret", () -> tab));
        TAB.register(e);
    }

    public static boolean isLoaded() {
        return isLOADED;
    }

    public static <SP extends StructurePlacement> RegistryObject<StructurePlacementType<SP>> registerPlacementType(DeferredRegister<StructurePlacementType<?>> def, String identifier, RegistryObject<StructurePlacementType<SP>> structurePlacementType) {
        return def.register(identifier, structurePlacementType);
    }
}

