/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomeStructure
extends Structure {
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final JigsawStructure.MaxDistance maxDistanceFromCenter;
    private final String uniqueIdentifier;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public AwesomeStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String uniqueIdentifier, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, JigsawStructure.MaxDistance maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.uniqueIdentifier = uniqueIdentifier;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public static <T extends AwesomeStructure> MapCodec<T> getDefaultCodec(int size, int maxDistanceFromCenter, Function<String, Boolean> bindEnabledFromConfiguration, Function8<Structure.StructureSettings, Holder<StructureTemplatePool>, String, Optional<ResourceLocation>, Integer, HeightProvider, Optional<Heightmap.Types>, JigsawStructure.MaxDistance, T> structureCreator) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)AwesomeStructure.settingsCodec((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(AwesomeStructure::startPool), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomeStructure::uniqueIdentifier), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(AwesomeStructure::startJigsawName), (App)Codec.intRange((int)0, (int)(size + 1)).fieldOf("size").forGetter(AwesomeStructure::size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(AwesomeStructure::startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(AwesomeStructure::projectStartToHeightmap), (App)JigsawStructure.MaxDistance.CODEC.fieldOf("max_distance_from_center").forGetter(AwesomeStructure::maxDistanceFromCenter)).apply((Applicative)i, (_config, _startPool, _uniqueIdentifier, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter) -> (AwesomeStructure)((Object)((Object)((Object)structureCreator.apply((Object)new Structure.StructureSettings((Boolean)bindEnabledFromConfiguration.apply((String)_uniqueIdentifier) != false ? _config.biomes() : AwesomeStructure.onDisabledStructure(_uniqueIdentifier), _config.spawnOverrides(), _config.step(), _config.terrainAdaptation()), _startPool, _uniqueIdentifier, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter)))))).stable();
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx) {
        if (!this.canGenerate(ctx)) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)ctx, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)this.getInitialStartPosition(ctx), (boolean)false, this.projectStartToHeightmap, (JigsawStructure.MaxDistance)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    protected BlockPos getInitialStartPosition(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx) {
        return ctx.chunkPos().getMiddleBlockPosition(0);
    }

    protected abstract boolean canGenerate(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext var1);

    private static HolderSet<Biome> onDisabledStructure(String _uniqueIdentifier) {
        LibraryFerret.LOGGER.info("structure disabled: " + _uniqueIdentifier);
        return HolderSet.direct((Holder[])new Holder[0]);
    }

    public static boolean isValidStructureBiome(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext ctx, int biomeRange) {
        if (!(ctx.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            ChunkPos chunkPos = ctx.chunkPos();
            for (int curChunkX = chunkPos.x - biomeRange; curChunkX <= chunkPos.x + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.z - biomeRange; curChunkZ <= chunkPos.z + biomeRange; ++curChunkZ) {
                    Holder biome = ctx.biomeSource().getNoiseBiome(curChunkX << 2, 16, curChunkZ << 2, ctx.randomState().sampler());
                    if (ctx.validBiome().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmptyFluidState(Structure.GenerationContext ctx, @NotNull BlockPos position, Heightmap.Types projectStartToHeightmap) {
        return ctx.chunkGenerator().getBaseColumn(position.getX(), position.getZ(), ctx.heightAccessor(), ctx.randomState()).getBlock(ctx.chunkGenerator().getFirstOccupiedHeight(position.getX(), position.getZ(), projectStartToHeightmap, ctx.heightAccessor(), ctx.randomState())).getFluidState().isEmpty();
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public final Holder<StructureTemplatePool> startPool() {
        return this.startPool;
    }

    public final Optional<ResourceLocation> startJigsawName() {
        return this.startJigsawName;
    }

    public final int size() {
        return this.size;
    }

    public final HeightProvider startHeight() {
        return this.startHeight;
    }

    public final Optional<Heightmap.Types> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public final JigsawStructure.MaxDistance maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }
}

