/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.utils.TrackingConsumer;
import java.net.http.HttpResponse;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public class TrackingBodySubscriber<T>
implements HttpResponse.BodySubscriber<T> {
    private final HttpResponse.BodySubscriber<T> delegate;
    private final TrackingConsumer consumer;
    private long receivedBytes;
    private final long contentLengthIfKnown;

    public TrackingBodySubscriber(HttpResponse.BodySubscriber<T> delegate, TrackingConsumer consumer, long contentLengthIfKnown) {
        this.delegate = delegate;
        this.consumer = consumer;
        this.contentLengthIfKnown = contentLengthIfKnown;
    }

    @Override
    public CompletionStage<T> getBody() {
        return this.delegate.getBody();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.consumer.start().accept(this.contentLengthIfKnown);
        this.delegate.onSubscribe(subscription);
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        this.receivedBytes += this.countBytes(item);
        this.delegate.onNext(item);
        this.consumer.progressConsumer().accept(this.receivedBytes, this.contentLengthIfKnown);
    }

    @Override
    public void onError(Throwable throwable) {
        this.consumer.onComplete().accept(Optional.of(throwable));
        this.delegate.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.consumer.onComplete().accept(Optional.empty());
        this.delegate.onComplete();
    }

    private long countBytes(List<ByteBuffer> buffers) {
        return buffers.stream().mapToLong(Buffer::remaining).sum();
    }

    public static <T> HttpResponse.BodyHandler<T> bodyHandler(HttpResponse.BodyHandler<T> delegate, TrackingConsumer consumer) {
        return responseInfo -> new TrackingBodySubscriber(delegate.apply(responseInfo), consumer, responseInfo.headers().firstValueAsLong("Content-Length").orElse(-1L));
    }
}

