/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.InputBindingBuilderImpl;
import dev.isxander.controlify.bindings.InputBindingImpl;
import dev.isxander.controlify.bindings.InputBindingSupplierImpl;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.bindings.output.KeyMappingEmulationOutput;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;

public class ControlifyBindApiImpl
implements ControlifyBindApi {
    public static final ControlifyBindApiImpl INSTANCE = new ControlifyBindApiImpl();
    private final List<RegistryEntry> bindEntries = new ArrayList<RegistryEntry>();
    private final Map<KeyMapping, List<InputBindingSupplier>> keyMappingCorrelations = new HashMap<KeyMapping, List<InputBindingSupplier>>();
    private boolean locked;

    @Override
    public InputBindingSupplier registerBinding(ControlifyBindApi.RegistryCallback callback) {
        return this.registerBinding(callback, c -> true);
    }

    @Override
    public InputBindingSupplier registerBinding(ControlifyBindApi.RegistryCallback callback, Predicate<ControllerEntity> filter) {
        this.checkLocked();
        InputBindingBuilderImpl builder = new InputBindingBuilderImpl();
        callback.apply(builder);
        Function<ControllerEntity, InputBindingImpl> finaliser = builder::build;
        ResourceLocation bindId = builder.getIdAndLock();
        this.bindEntries.add(new RegistryEntry(filter, finaliser, builder.getKeyEmulation(), builder.getKeyEmulationToggle(), bindId));
        for (KeyMapping key : builder.getKeyCorrelations()) {
            this.keyMappingCorrelations.computeIfAbsent(key, k -> new ArrayList()).add(this.createSupplier(bindId));
        }
        return this.createSupplier(bindId);
    }

    @Override
    public List<InputBindingSupplier> getKeyCorrelation(KeyMapping key) {
        return Optional.ofNullable(this.keyMappingCorrelations.get(key)).orElse(List.of());
    }

    @Override
    public void registerRadialIcon(ResourceLocation id, RadialIcon icon) {
        this.checkLocked();
        RadialIcons.registerIcon(id, icon);
    }

    @Override
    public void registerBindContext(BindContext context) {
        BindContext.CONTEXTS.put(context.id(), context);
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Registry is locked. Cannot add bind now.");
        }
    }

    public List<InputBinding> provideBindsForController(ControllerEntity controller) {
        ArrayList<InputBinding> bindings = new ArrayList<InputBinding>();
        for (RegistryEntry entry : this.bindEntries) {
            if (!entry.filter().test(controller)) continue;
            InputBindingImpl binding = entry.builder().apply(controller);
            if (entry.emulation() != null) {
                BooleanSupplier emulationToggle = null;
                if (entry.emulationToggle() != null) {
                    emulationToggle = () -> entry.emulationToggle().apply(controller);
                }
                binding.addDigitalOutput(InputBinding.KEY_EMULATION, new KeyMappingEmulationOutput(controller, binding, entry.emulation(), emulationToggle));
            }
            bindings.add(binding);
        }
        return bindings;
    }

    @Override
    public InputBindingSupplier createSupplier(ResourceLocation bindingId) {
        return new InputBindingSupplierImpl(bindingId);
    }

    public void lock() {
        this.locked = true;
    }

    @Override
    public Stream<ResourceLocation> getAllBindIds() {
        return this.bindEntries.stream().map(RegistryEntry::id);
    }

    private record RegistryEntry(Predicate<ControllerEntity> filter, Function<ControllerEntity, InputBindingImpl> builder, KeyMapping emulation, Function<ControllerEntity, Boolean> emulationToggle, ResourceLocation id) {
    }
}

