/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.input;

import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.utils.ControllerUtils;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class DeadzoneControllerStateView
implements ControllerStateView {
    private final ControllerStateView view;
    private final InputComponent input;

    public DeadzoneControllerStateView(ControllerStateView view, InputComponent input) {
        this.view = view;
        this.input = input;
    }

    @Override
    public boolean isButtonDown(ResourceLocation button) {
        return this.view.isButtonDown(button);
    }

    @Override
    public Set<ResourceLocation> getButtons() {
        return this.view.getButtons();
    }

    @Override
    public float getAxisState(ResourceLocation axis) {
        float rawAxis = this.view.getAxisState(axis);
        Optional<ResourceLocation> deadzoneId = this.input.getDeadzoneForAxis(axis);
        float deadzone = deadzoneId.map(id -> ((InputComponent.Config)this.input.confObj()).deadzones.get(id)).orElse(Float.valueOf(0.0f)).floatValue();
        return ControllerUtils.deadzone(rawAxis, deadzone);
    }

    @Override
    public Set<ResourceLocation> getAxes() {
        return this.view.getAxes();
    }

    @Override
    public float getAxisResting(ResourceLocation axis) {
        return this.view.getAxisResting(axis);
    }

    @Override
    public HatState getHatState(ResourceLocation hat) {
        return this.view.getHatState(hat);
    }

    @Override
    public Set<ResourceLocation> getHats() {
        return this.view.getHats();
    }
}

