/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.layout;

import dev.isxander.controlify.gui.layout.AbstractLayoutComponent;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.commons.lang3.Validate;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class RowLayoutComponent<T extends RenderComponent>
extends AbstractLayoutComponent<T> {
    private final int elementPaddingHorizontal;
    private final int rowPaddingLeft;
    private final int rowPaddingRight;
    private final int rowPaddingTop;
    private final int rowPaddingBottom;
    private final ElementPosition elementPosition;

    private RowLayoutComponent(Collection<? extends T> elements, int elementPaddingHorizontal, int rowPaddingLeft, int rowPaddingRight, int rowPaddingTop, int rowPaddingBottom, ElementPosition elementPosition) {
        for (RenderComponent element : elements) {
            this.insertTop(element);
        }
        this.elementPaddingHorizontal = elementPaddingHorizontal;
        this.rowPaddingLeft = rowPaddingLeft;
        this.rowPaddingRight = rowPaddingRight;
        this.rowPaddingTop = rowPaddingTop;
        this.rowPaddingBottom = rowPaddingBottom;
        this.elementPosition = elementPosition;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float deltaTime) {
        int height = this.getMaxChildHeight();
        if (height == -1) {
            return;
        }
        int xOffset = 0;
        for (RenderComponent element : this.getChildComponents()) {
            if (!element.isVisible()) continue;
            element.render(graphics, x + this.rowPaddingLeft + xOffset, y + this.rowPaddingTop + this.elementPosition.positionFunction.apply(height, element.size().y()), deltaTime);
            xOffset += element.size().x() + this.elementPaddingHorizontal;
        }
    }

    @Override
    public Vector2ic size() {
        return new Vector2i(this.getSumWidth() + this.rowPaddingLeft + this.rowPaddingRight, this.getMaxChildHeight() + this.rowPaddingTop + this.rowPaddingBottom);
    }

    private int getMaxChildHeight() {
        return this.getChildComponents().stream().filter(RenderComponent::isVisible).map(RenderComponent::size).mapToInt(Vector2ic::y).max().orElse(-1);
    }

    private int getSumWidth() {
        return this.getChildComponents().stream().filter(RenderComponent::isVisible).map(RenderComponent::size).mapToInt(size -> size.x() + this.elementPaddingHorizontal).sum() - this.elementPaddingHorizontal;
    }

    @Override
    public boolean isVisible() {
        return this.getChildComponents().stream().anyMatch(RenderComponent::isVisible);
    }

    public static <T extends RenderComponent> Builder<T> builder() {
        return new Builder();
    }

    public static enum ElementPosition {
        TOP((rowHeight, elementHeight) -> 0),
        BOTTOM((rowHeight, elementHeight) -> rowHeight - elementHeight),
        MIDDLE((rowHeight, elementHeight) -> rowHeight / 2 - elementHeight / 2);

        public final BiFunction<Integer, Integer, Integer> positionFunction;

        private ElementPosition(BiFunction<Integer, Integer, Integer> positionFunction) {
            this.positionFunction = positionFunction;
        }
    }

    public static class Builder<T extends RenderComponent> {
        private final List<T> elements = new ArrayList<T>();
        private int elementPaddingHorizontal;
        private int rowPaddingLeft;
        private int rowPaddingRight;
        private int rowPaddingTop;
        private int rowPaddingBottom;
        private ElementPosition elementPosition = null;

        public Builder<T> element(T element) {
            this.elements.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<T> elements(T ... elements) {
            this.elements.addAll(Arrays.asList(elements));
            return this;
        }

        public Builder<T> elements(Collection<? extends T> elements) {
            this.elements.addAll(elements);
            return this;
        }

        public Builder<T> spacing(int padding) {
            this.elementPaddingHorizontal = padding;
            return this;
        }

        public Builder<T> rowPadding(int left, int right, int top, int bottom) {
            this.rowPaddingLeft = left;
            this.rowPaddingRight = right;
            this.rowPaddingTop = top;
            this.rowPaddingBottom = bottom;
            return this;
        }

        public Builder<T> rowPadding(int horizontal, int vertical) {
            return this.rowPadding(horizontal, horizontal, vertical, vertical);
        }

        public Builder<T> rowPadding(int padding) {
            return this.rowPadding(padding, padding, padding, padding);
        }

        public Builder<T> elementPosition(ElementPosition elementPosition) {
            this.elementPosition = elementPosition;
            return this;
        }

        public RowLayoutComponent<T> build() {
            Validate.notEmpty(this.elements, (String)"No elements were added to the row!", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)this.elementPosition), (String)"Element position cannot be null!", (Object[])new Object[0]);
            return new RowLayoutComponent<T>(this.elements, this.elementPaddingHorizontal, this.rowPaddingLeft, this.rowPaddingRight, this.rowPaddingTop, this.rowPaddingBottom, this.elementPosition);
        }
    }
}

