/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.config.GlobalSettings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.reacharound.ReachAroundMode;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.DebugDump;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GlobalSettingsScreenFactory {
    public static Screen createGlobalSettingsScreen(Screen parent) {
        GlobalSettings globalSettings = Controlify.instance().config().globalSettings();
        AtomicReference whitelist = new AtomicReference();
        boolean is12106OrLater = false;
        return YetAnotherConfigLib.createBuilder().title((Component)Component.translatable((String)"controlify.gui.global_settings.title")).save(() -> Controlify.instance().config().save()).category(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"controlify.gui.global_settings.title")).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"controlify.gui.open_issue_tracker")).action((screen, button) -> Util.getPlatform().openUri("https://github.com/isxander/controlify/issues")).build()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"controlify.gui.server_options")).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.reach_around")).description(state -> OptionDescription.createBuilder().webpImage(GlobalSettingsScreenFactory.screenshot("reach-around-placement.webp")).text(new Component[]{Component.translatable((String)"controlify.gui.reach_around.tooltip")}).text(new Component[]{Component.translatable((String)"controlify.gui.reach_around.tooltip.parity").withStyle(ChatFormatting.GRAY)}).text(new Component[]{state == ReachAroundMode.EVERYWHERE ? Component.translatable((String)"controlify.gui.reach_around.tooltip.warning").withStyle(ChatFormatting.RED) : Component.empty()}).text(new Component[]{ServerPolicies.REACH_AROUND.getPolicy() == ServerPolicy.DISALLOWED ? Component.translatable((String)"controlify.gui.server_controlled").withStyle(ChatFormatting.GOLD) : Component.empty()}).build()).binding((Object)GlobalSettings.DEFAULT.reachAround, () -> globalSettings.reachAround, v -> {
            globalSettings.reachAround = v;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(ReachAroundMode.class).formatValue(mode -> switch (ServerPolicies.REACH_AROUND.getPolicy()) {
            default -> throw new MatchException(null, null);
            case ServerPolicy.UNSET, ServerPolicy.ALLOWED -> mode.getDisplayName();
            case ServerPolicy.DISALLOWED -> CommonComponents.OPTION_OFF;
        })).available(ServerPolicies.REACH_AROUND.get()).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.allow_server_rumble")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.allow_server_rumble.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.allowServerRumble, () -> globalSettings.allowServerRumble, v -> {
            globalSettings.allowServerRumble = v;
        }).controller(TickBoxControllerBuilder::create).addListener((opt, val) -> ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().clearEffects())).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.keyboard_movement")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.keyboard_movement.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.alwaysKeyboardMovement, () -> globalSettings.alwaysKeyboardMovement, v -> {
            globalSettings.alwaysKeyboardMovement = v;
        }).controller(TickBoxControllerBuilder::create).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"controlify.gui.add_server_to_keyboard_move_whitelist")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.add_server_to_keyboard_move_whitelist.tooltip")}).build()).action((screen, button) -> {
            ServerData server = Minecraft.getInstance().getCurrentServer();
            if (server != null) {
                ((ListOption)whitelist.get()).insertNewEntry().requestSet((Object)server.ip);
            }
        }).available(Minecraft.getInstance().getCurrentServer() != null).build()).build()).group((OptionGroup)Util.make(() -> {
            ListOption list = ListOption.createBuilder().name((Component)Component.translatable((String)"controlify.gui.keyboard_movement_whitelist")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.keyboard_movement_whitelist.tooltip")}).build()).binding(GlobalSettings.DEFAULT.keyboardMovementWhitelist, () -> globalSettings.keyboardMovementWhitelist, v -> {
                globalSettings.keyboardMovementWhitelist = v;
            }).controller(StringControllerBuilder::create).initial((Object)"Server IP here").build();
            whitelist.set(list);
            return list;
        })).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"controlify.gui.miscellaneous")).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.ingame_button_guide_scale")).description(val -> OptionDescription.createBuilder().text(new Component[]{is12106OrLater ? Component.literal((String)"This setting is currently broken on 1.21.6+").withStyle(ChatFormatting.RED) : Component.empty()}).text(new Component[]{Component.translatable((String)"controlify.gui.ingame_button_guide_scale.tooltip")}).text(new Component[]{val.floatValue() != 1.0f ? Component.translatable((String)"controlify.gui.ingame_button_guide_scale.tooltip.warning").withStyle(ChatFormatting.RED) : Component.empty()}).build()).binding((Object)Float.valueOf(GlobalSettings.DEFAULT.ingameButtonGuideScale), () -> Float.valueOf(is12106OrLater ? 1.0f : globalSettings.ingameButtonGuideScale), v -> {
            globalSettings.ingameButtonGuideScale = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.5f), (Number)Float.valueOf(1.5f))).step((Number)Float.valueOf(0.05f))).formatValue(v -> Component.literal((String)String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f))))).available(!is12106OrLater).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.ui_sounds")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.ui_sounds.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.extraUiSounds, () -> globalSettings.extraUiSounds, v -> {
            globalSettings.extraUiSounds = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.out_of_focus_input")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.out_of_focus_input.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.outOfFocusInput, () -> globalSettings.outOfFocusInput, v -> {
            globalSettings.outOfFocusInput = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.notify_low_battery")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.notify_low_battery.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.notifyLowBattery, () -> globalSettings.notifyLowBattery, v -> {
            globalSettings.notifyLowBattery = v;
        }).controller(TickBoxControllerBuilder::create).build()).optionIf(SteamDeckUtil.IS_STEAM_DECK, Option.createBuilder().name((Component)Component.translatable((String)"controlify.gui.use_enhanced_steam_deck_driver")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.use_enhanced_steam_deck_driver.tooltip")}).build()).binding((Object)GlobalSettings.DEFAULT.useEnhancedSteamDeckDriver, () -> globalSettings.useEnhancedSteamDeckDriver, v -> {
            globalSettings.useEnhancedSteamDeckDriver = v;
        }).controller(TickBoxControllerBuilder::create).flag(new OptionFlag[]{OptionFlag.GAME_RESTART}).build()).option((Option)ButtonOption.createBuilder().name((Component)Component.translatable((String)"controlify.gui.copy_debug_dump")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"controlify.gui.copy_debug_dump.tooltip")}).build()).action((screen, btn) -> {
            String dump = DebugDump.dumpDebug();
            String formatted = "Here's my Controlify debug dump\n```\n%s\n```\n".formatted(dump).stripIndent();
            Minecraft.getInstance().keyboardHandler.setClipboard(formatted);
        }).build()).build()).build()).build().generateScreen(parent);
    }

    private static ResourceLocation screenshot(String filename) {
        return CUtil.rl("textures/screenshots/" + filename);
    }
}

