/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.ingame.InGameInputHandler;
import net.minecraft.client.player.ClientInput;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.Validate;

public class DualInput
extends ClientInput {
    private final ClientInput input1;
    private final ClientInput input2;

    public DualInput(ClientInput input1, ClientInput input2) {
        Validate.isTrue((!(input1 instanceof DualInput) ? 1 : 0) != 0, (String)"Cannot nest DualInputs", (Object[])new Object[0]);
        Validate.isTrue((!(input2 instanceof DualInput) ? 1 : 0) != 0, (String)"Cannot nest DualInputs", (Object[])new Object[0]);
        this.input1 = input1;
        this.input2 = input2;
    }

    public void tick(boolean slowDown, float movementMultiplier) {
        this.input1.tick(slowDown, movementMultiplier);
        this.input2.tick(slowDown, movementMultiplier);
        Vec2 input1MoveVec = InGameInputHandler.getMoveVec(this.input1);
        Vec2 input2MoveVec = InGameInputHandler.getMoveVec(this.input2);
        this.setMoveVec(Mth.clamp((float)(input1MoveVec.y + input2MoveVec.y), (float)-1.0f, (float)1.0f), Mth.clamp((float)(input1MoveVec.x + input2MoveVec.x), (float)-1.0f, (float)1.0f));
        Input input1 = this.input1.keyPresses;
        Input input2 = this.input2.keyPresses;
        this.keyPresses = new Input(input1.forward() || input2.forward(), input1.backward() || input2.backward(), input1.left() || input2.left(), input1.right() || input2.right(), input1.jump() || input2.jump(), input1.shift() || input2.shift(), input1.sprint() || input2.sprint());
    }

    private void setMoveVec(float forward, float left) {
        this.forwardImpulse = forward;
        this.leftImpulse = left;
    }
}

