/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.patches.analogueboat;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.isxander.controlify.fixes.boatfix.AnalogBoatInput;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractBoat.class})
public abstract class BoatMixin
implements AnalogBoatInput {
    @Shadow
    private float deltaRotation;
    @Shadow
    private boolean inputLeft;
    @Shadow
    private boolean inputRight;
    @Shadow
    private boolean inputUp;
    @Shadow
    private boolean inputDown;
    @Unique
    private float analogForward;
    @Unique
    private float analogRight;
    @Unique
    private boolean usingAnalogInput;
    @Unique
    private static final String TARGET_CLASS = "Lnet/minecraft/world/entity/vehicle/AbstractBoat";

    @Inject(method={"controlBoat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;getYRot()F", ordinal=0)})
    private void rotateBoatAnalog(CallbackInfo ci) {
        if (this.usingAnalogInput) {
            this.deltaRotation += this.analogRight;
        }
    }

    @ModifyVariable(method={"controlBoat"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private float forwardBoatAnalog(float forwardVelocity) {
        if (!this.usingAnalogInput) {
            return forwardVelocity;
        }
        float velocity = this.analogForward > 0.0f ? this.analogForward * 0.04f : this.analogForward * 0.005f;
        return forwardVelocity + velocity;
    }

    @ModifyExpressionValue(method={"controlBoat"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;inputLeft:Z", opcode=180, ordinal=0), @At(value="FIELD", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;inputRight:Z", opcode=180, ordinal=0), @At(value="FIELD", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;inputUp:Z", opcode=180, ordinal=1), @At(value="FIELD", target="Lnet/minecraft/world/entity/vehicle/AbstractBoat;inputDown:Z", opcode=180, ordinal=1)})
    private boolean shouldDoDigitalInput(boolean original) {
        return !this.usingAnalogInput && original;
    }

    @Override
    public void controlify$setAnalogInput(float forward, float right) {
        this.usingAnalogInput = true;
        this.analogForward = forward;
        this.analogRight = right;
        this.inputLeft = right < 0.0f;
        this.inputRight = right > 0.0f;
        this.inputUp = forward > 0.0f;
        this.inputDown = forward < 0.0f;
    }

    @Inject(method={"setInput"}, at={@At(value="HEAD")})
    private void onUseDigitalInput(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack, CallbackInfo ci) {
        this.usingAnalogInput = false;
    }
}

